// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionResultMetaV1's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionResultMetaV1
 * {
 *     ExtensionPoint ext;
 *
 *     TransactionResultPair result;
 *     LedgerEntryChanges feeProcessing;
 *     TransactionMeta txApplyProcessing;
 *
 *     LedgerEntryChanges postTxApplyFeeProcessing;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionResultMetaV1 implements XdrElement {
  private ExtensionPoint ext;
  private TransactionResultPair result;
  private LedgerEntryChanges feeProcessing;
  private TransactionMeta txApplyProcessing;
  private LedgerEntryChanges postTxApplyFeeProcessing;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    result.encode(stream);
    feeProcessing.encode(stream);
    txApplyProcessing.encode(stream);
    postTxApplyFeeProcessing.encode(stream);
  }

  public static TransactionResultMetaV1 decode(XdrDataInputStream stream) throws IOException {
    TransactionResultMetaV1 decodedTransactionResultMetaV1 = new TransactionResultMetaV1();
    decodedTransactionResultMetaV1.ext = ExtensionPoint.decode(stream);
    decodedTransactionResultMetaV1.result = TransactionResultPair.decode(stream);
    decodedTransactionResultMetaV1.feeProcessing = LedgerEntryChanges.decode(stream);
    decodedTransactionResultMetaV1.txApplyProcessing = TransactionMeta.decode(stream);
    decodedTransactionResultMetaV1.postTxApplyFeeProcessing = LedgerEntryChanges.decode(stream);
    return decodedTransactionResultMetaV1;
  }

  public static TransactionResultMetaV1 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionResultMetaV1 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
