// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Value's original definition in the XDR file is:
 *
 * <pre>
 * typedef opaque Value&lt;&gt;;
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Value implements XdrElement {
  private byte[] Value;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int ValueSize = Value.length;
    stream.writeInt(ValueSize);
    stream.write(getValue(), 0, ValueSize);
  }

  public static Value decode(XdrDataInputStream stream) throws IOException {
    Value decodedValue = new Value();
    int ValueSize = stream.readInt();
    decodedValue.Value = new byte[ValueSize];
    stream.read(decodedValue.Value, 0, ValueSize);
    return decodedValue;
  }

  public static Value fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Value fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
