/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Address;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Memo;
import org.stellar.sdk.MuxedAccount;
import org.stellar.sdk.Network;
import org.stellar.sdk.SorobanDataBuilder;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.TrustLineAsset;
import org.stellar.sdk.operations.InvokeHostFunctionOperation;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.operations.RestoreFootprintOperation;
import org.stellar.sdk.scval.Scv;
import org.stellar.sdk.xdr.ContractDataDurability;
import org.stellar.sdk.xdr.InvokeContractArgs;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SCValType;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.SorobanAuthorizedFunction;
import org.stellar.sdk.xdr.SorobanAuthorizedFunctionType;
import org.stellar.sdk.xdr.SorobanAuthorizedInvocation;
import org.stellar.sdk.xdr.SorobanCredentials;
import org.stellar.sdk.xdr.SorobanCredentialsType;
import org.stellar.sdk.xdr.SorobanTransactionData;

public class TransactionBuilder {
    private final TransactionBuilderAccount sourceAccount;
    private Memo memo;
    private final List<Operation> operations;
    private Long baseFee;
    private final Network network;
    @NonNull
    private TransactionPreconditions preconditions;
    private SorobanTransactionData sorobanData;
    private BigInteger txTimeout;

    public TransactionBuilder(@NonNull TransactionBuilderAccount sourceAccount, @NonNull Network network) {
        if (sourceAccount == null) {
            throw new NullPointerException("sourceAccount is marked non-null but is null");
        }
        if (network == null) {
            throw new NullPointerException("network is marked non-null but is null");
        }
        this.sourceAccount = sourceAccount;
        this.network = network;
        this.operations = new ArrayList<Operation>();
        this.preconditions = TransactionPreconditions.builder().build();
    }

    public int getOperationsCount() {
        return this.operations.size();
    }

    public TransactionBuilder addOperation(@NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.operations.add(operation);
        return this;
    }

    public TransactionBuilder addOperations(@NonNull Collection<Operation> operations) {
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.operations.addAll(operations);
        return this;
    }

    public TransactionBuilder addPreconditions(@NonNull TransactionPreconditions preconditions) {
        if (preconditions == null) {
            throw new NullPointerException("preconditions is marked non-null but is null");
        }
        this.preconditions = preconditions;
        return this;
    }

    public TransactionBuilder addMemo(@NonNull Memo memo) {
        if (memo == null) {
            throw new NullPointerException("memo is marked non-null but is null");
        }
        if (this.memo != null) {
            throw new IllegalStateException("Memo has been already added.");
        }
        this.memo = memo;
        return this;
    }

    public TransactionBuilder setTimeout(BigInteger timeout2) {
        if (timeout2.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.txTimeout = timeout2;
        return this;
    }

    public TransactionBuilder setTimeout(long timeout2) {
        return this.setTimeout(BigInteger.valueOf(timeout2));
    }

    public TransactionBuilder setBaseFee(long baseFee) {
        if (baseFee < 100L) {
            throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
        }
        this.baseFee = baseFee;
        return this;
    }

    public Transaction build() {
        TransactionPreconditions txPreconditions;
        if (this.preconditions.getTimeBounds() != null && this.txTimeout != null) {
            throw new IllegalStateException("Can not set both TransactionPreconditions.timeBounds and timeout.");
        }
        if (this.txTimeout != null) {
            BigInteger maxTime = !TransactionPreconditions.TIMEOUT_INFINITE.equals(this.txTimeout) ? this.txTimeout.add(BigInteger.valueOf(System.currentTimeMillis() / 1000L)) : TransactionPreconditions.TIMEOUT_INFINITE;
            txPreconditions = this.preconditions.toBuilder().timeBounds(new TimeBounds(BigInteger.ZERO, maxTime)).build();
        } else {
            txPreconditions = this.preconditions;
        }
        txPreconditions.validate();
        if (this.baseFee == null) {
            throw new IllegalStateException("baseFee has to be set. you must call setBaseFee().");
        }
        if (this.network == null) {
            throw new IllegalStateException("network has to be set. you must call setNetwork().");
        }
        long sequenceNumber = this.sourceAccount.getIncrementedSequenceNumber();
        Operation[] operations = new Operation[this.operations.size()];
        operations = this.operations.toArray(operations);
        long fee = (long)operations.length * this.baseFee;
        if (this.sorobanData != null) {
            fee += this.sorobanData.getResourceFee().getInt64().longValue();
        }
        Transaction transaction = new Transaction(this.sourceAccount.getAccountId(), fee, sequenceNumber, operations, this.memo, txPreconditions, this.sorobanData, this.network);
        this.sourceAccount.setSequenceNumber(sequenceNumber);
        return transaction;
    }

    public TransactionBuilder setSorobanData(SorobanTransactionData sorobanData) {
        this.sorobanData = new SorobanDataBuilder(sorobanData).build();
        return this;
    }

    public TransactionBuilder setSorobanData(String sorobanData) {
        this.sorobanData = new SorobanDataBuilder(sorobanData).build();
        return this;
    }

    public Transaction buildPaymentToContractTransaction(String destination, Asset asset, BigDecimal amount, @Nullable String source2) {
        SorobanDataBuilder.Resources resources = new SorobanDataBuilder.Resources(400000L, 1000L, 1000L);
        return this.buildPaymentToContractTransaction(destination, asset, amount, resources, 5000000L, source2);
    }

    public Transaction buildPaymentToContractTransaction(String destination, Asset asset, BigDecimal amount, SorobanDataBuilder.Resources resources, Long resourceFee, @Nullable String source2) {
        if (!StrKey.isValidContract(destination)) {
            throw new IllegalArgumentException("destination is not a valid contract address");
        }
        String fromAddress = source2 != null ? new MuxedAccount(source2).getAccountId() : new MuxedAccount(this.sourceAccount.getAccountId()).getAccountId();
        String contractId = asset.getContractId(this.network);
        String functionName = "transfer";
        BigInteger tokenAmount = BigInteger.valueOf(Operation.toXdrAmount(Operation.formatAmountScale(amount)));
        List<SCVal> parameters = Arrays.asList(Scv.toAddress(fromAddress), Scv.toAddress(destination), Scv.toInt128(tokenAmount));
        SorobanCredentials credentials = SorobanCredentials.builder().discriminant(SorobanCredentialsType.SOROBAN_CREDENTIALS_SOURCE_ACCOUNT).build();
        SorobanAuthorizedInvocation rootInvocation = SorobanAuthorizedInvocation.builder().function(SorobanAuthorizedFunction.builder().discriminant(SorobanAuthorizedFunctionType.SOROBAN_AUTHORIZED_FUNCTION_TYPE_CONTRACT_FN).contractFn(InvokeContractArgs.builder().contractAddress(new Address(contractId).toSCAddress()).functionName(Scv.toSymbol(functionName).getSym()).args(parameters.toArray(new SCVal[0])).build()).build()).subInvocations(new SorobanAuthorizedInvocation[0]).build();
        SorobanAuthorizationEntry auth = SorobanAuthorizationEntry.builder().credentials(credentials).rootInvocation(rootInvocation).build();
        Operation op = ((InvokeHostFunctionOperation.InvokeHostFunctionOperationBuilder)((Operation.OperationBuilder)InvokeHostFunctionOperation.invokeContractFunctionOperationBuilder(contractId, functionName, parameters).auth(Collections.singletonList(auth))).sourceAccount(source2)).build();
        LedgerKey contractInstanceLedgerKey = LedgerKey.builder().discriminant(LedgerEntryType.CONTRACT_DATA).contractData(LedgerKey.LedgerKeyContractData.builder().contract(new Address(contractId).toSCAddress()).key(SCVal.builder().discriminant(SCValType.SCV_LEDGER_KEY_CONTRACT_INSTANCE).build()).durability(ContractDataDurability.PERSISTENT).build()).build();
        LedgerKey balanceLedgerKey = LedgerKey.builder().discriminant(LedgerEntryType.CONTRACT_DATA).contractData(LedgerKey.LedgerKeyContractData.builder().contract(new Address(contractId).toSCAddress()).key(Scv.toVec(Arrays.asList(Scv.toSymbol("Balance"), Scv.toAddress(destination)))).durability(ContractDataDurability.PERSISTENT).build()).build();
        ArrayList<LedgerKey> readOnly = new ArrayList<LedgerKey>();
        ArrayList<LedgerKey> readWrite = new ArrayList<LedgerKey>();
        if (asset instanceof AssetTypeNative) {
            readOnly.add(contractInstanceLedgerKey);
            readWrite.add(LedgerKey.builder().discriminant(LedgerEntryType.ACCOUNT).account(LedgerKey.LedgerKeyAccount.builder().accountID(KeyPair.fromAccountId(fromAddress).getXdrAccountId()).build()).build());
            readWrite.add(balanceLedgerKey);
        } else {
            String assetIssuer = ((AssetTypeCreditAlphaNum)asset).getIssuer();
            readOnly.add(LedgerKey.builder().discriminant(LedgerEntryType.ACCOUNT).account(LedgerKey.LedgerKeyAccount.builder().accountID(KeyPair.fromAccountId(assetIssuer).getXdrAccountId()).build()).build());
            readOnly.add(contractInstanceLedgerKey);
            if (!assetIssuer.equals(fromAddress)) {
                readWrite.add(LedgerKey.builder().discriminant(LedgerEntryType.TRUSTLINE).trustLine(LedgerKey.LedgerKeyTrustLine.builder().accountID(KeyPair.fromAccountId(fromAddress).getXdrAccountId()).asset(new TrustLineAsset(asset).toXdr()).build()).build());
            }
            readWrite.add(balanceLedgerKey);
        }
        SorobanTransactionData sorobanData = new SorobanDataBuilder().setReadOnly(readOnly).setReadWrite(readWrite).setResourceFee(resourceFee).setResources(resources).build();
        this.addOperation(op);
        this.setSorobanData(sorobanData);
        return this.build();
    }

    public Transaction buildRestoreAssetBalanceEntryTransaction(String balanceOwner, Asset asset, @Nullable String source2) {
        SorobanDataBuilder.Resources resources = new SorobanDataBuilder.Resources(0L, 500L, 500L);
        return this.buildRestoreAssetBalanceEntryTransaction(balanceOwner, asset, resources, 4000000L, source2);
    }

    public Transaction buildRestoreAssetBalanceEntryTransaction(String balanceOwner, Asset asset, SorobanDataBuilder.Resources resources, Long resourceFee, @Nullable String source2) {
        String contractId = asset.getContractId(this.network);
        LedgerKey balanceLedgerKey = LedgerKey.builder().discriminant(LedgerEntryType.CONTRACT_DATA).contractData(LedgerKey.LedgerKeyContractData.builder().contract(new Address(contractId).toSCAddress()).key(Scv.toVec(Arrays.asList(Scv.toSymbol("Balance"), Scv.toAddress(balanceOwner)))).durability(ContractDataDurability.PERSISTENT).build()).build();
        Operation op = ((RestoreFootprintOperation.RestoreFootprintOperationBuilder)RestoreFootprintOperation.builder().sourceAccount(source2)).build();
        SorobanTransactionData sorobanData = new SorobanDataBuilder().setReadOnly(new ArrayList<LedgerKey>()).setReadWrite(Collections.singletonList(balanceLedgerKey)).setResourceFee(resourceFee).setResources(resources).build();
        this.addOperation(op);
        this.setSorobanData(sorobanData);
        return this.build();
    }

    @Generated
    public TransactionBuilderAccount getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public Long getBaseFee() {
        return this.baseFee;
    }

    @Generated
    public Network getNetwork() {
        return this.network;
    }
}

