/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Price;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.CreatePassiveSellOfferOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class CreatePassiveSellOfferOperation
extends Operation {
    @NonNull
    private final Asset selling;
    @NonNull
    private final Asset buying;
    @NonNull
    private final BigDecimal amount;
    @NonNull
    private final Price price;

    public static CreatePassiveSellOfferOperation fromXdr(CreatePassiveSellOfferOp op) {
        Asset selling = Asset.fromXdr(op.getSelling());
        Asset buying = Asset.fromXdr(op.getBuying());
        BigDecimal amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        Price price = Price.fromXdr(op.getPrice());
        return new CreatePassiveSellOfferOperation(selling, buying, amount, price);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        CreatePassiveSellOfferOp op = new CreatePassiveSellOfferOp();
        op.setSelling(this.selling.toXdr());
        op.setBuying(this.buying.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        op.setPrice(this.price.toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_PASSIVE_SELL_OFFER);
        body.setCreatePassiveSellOfferOp(op);
        return body;
    }

    @Generated
    protected CreatePassiveSellOfferOperation(CreatePassiveSellOfferOperationBuilder<?, ?> b) {
        super(b);
        this.selling = ((CreatePassiveSellOfferOperationBuilder)b).selling;
        if (this.selling == null) {
            throw new NullPointerException("selling is marked non-null but is null");
        }
        this.buying = ((CreatePassiveSellOfferOperationBuilder)b).buying;
        if (this.buying == null) {
            throw new NullPointerException("buying is marked non-null but is null");
        }
        this.amount = ((CreatePassiveSellOfferOperationBuilder)b).amount;
        if (this.amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.price = ((CreatePassiveSellOfferOperationBuilder)b).price;
        if (this.price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
    }

    @Generated
    public static CreatePassiveSellOfferOperationBuilder<?, ?> builder() {
        return new CreatePassiveSellOfferOperationBuilderImpl();
    }

    @Generated
    public CreatePassiveSellOfferOperationBuilder<?, ?> toBuilder() {
        return new CreatePassiveSellOfferOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public Asset getSelling() {
        return this.selling;
    }

    @NonNull
    @Generated
    public Asset getBuying() {
        return this.buying;
    }

    @NonNull
    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public Price getPrice() {
        return this.price;
    }

    @Generated
    public String toString() {
        return "CreatePassiveSellOfferOperation(super=" + super.toString() + ", selling=" + this.getSelling() + ", buying=" + this.getBuying() + ", amount=" + this.getAmount() + ", price=" + this.getPrice() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePassiveSellOfferOperation)) {
            return false;
        }
        CreatePassiveSellOfferOperation other = (CreatePassiveSellOfferOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Asset this$selling = this.getSelling();
        Asset other$selling = other.getSelling();
        if (this$selling == null ? other$selling != null : !((Object)this$selling).equals(other$selling)) {
            return false;
        }
        Asset this$buying = this.getBuying();
        Asset other$buying = other.getBuying();
        if (this$buying == null ? other$buying != null : !((Object)this$buying).equals(other$buying)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Price this$price = this.getPrice();
        Price other$price = other.getPrice();
        return !(this$price == null ? other$price != null : !((Object)this$price).equals(other$price));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreatePassiveSellOfferOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Asset $selling = this.getSelling();
        result = result * 59 + ($selling == null ? 43 : $selling.hashCode());
        Asset $buying = this.getBuying();
        result = result * 59 + ($buying == null ? 43 : $buying.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Price $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        return result;
    }

    @Generated
    private CreatePassiveSellOfferOperation(@NonNull Asset selling, @NonNull Asset buying, @NonNull BigDecimal amount, @NonNull Price price) {
        if (selling == null) {
            throw new NullPointerException("selling is marked non-null but is null");
        }
        if (buying == null) {
            throw new NullPointerException("buying is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        this.selling = selling;
        this.buying = buying;
        this.amount = amount;
        this.price = price;
    }

    @Generated
    private static final class CreatePassiveSellOfferOperationBuilderImpl
    extends CreatePassiveSellOfferOperationBuilder<CreatePassiveSellOfferOperation, CreatePassiveSellOfferOperationBuilderImpl> {
        @Generated
        private CreatePassiveSellOfferOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected CreatePassiveSellOfferOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CreatePassiveSellOfferOperation build() {
            return new CreatePassiveSellOfferOperation(this);
        }
    }

    public static abstract class CreatePassiveSellOfferOperationBuilder<C extends CreatePassiveSellOfferOperation, B extends CreatePassiveSellOfferOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private Asset selling;
        @Generated
        private Asset buying;
        @Generated
        private BigDecimal amount;
        @Generated
        private Price price;

        public B amount(@NonNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = Operation.formatAmountScale(amount);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreatePassiveSellOfferOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CreatePassiveSellOfferOperation instance, CreatePassiveSellOfferOperationBuilder<?, ?> b) {
            b.selling(instance.selling);
            b.buying(instance.buying);
            b.amount(instance.amount);
            b.price(instance.price);
        }

        @Generated
        public B selling(@NonNull Asset selling) {
            if (selling == null) {
                throw new NullPointerException("selling is marked non-null but is null");
            }
            this.selling = selling;
            return (B)this.self();
        }

        @Generated
        public B buying(@NonNull Asset buying) {
            if (buying == null) {
                throw new NullPointerException("buying is marked non-null but is null");
            }
            this.buying = buying;
            return (B)this.self();
        }

        @Generated
        public B price(@NonNull Price price) {
            if (price == null) {
                throw new NullPointerException("price is marked non-null but is null");
            }
            this.price = price;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CreatePassiveSellOfferOperation.CreatePassiveSellOfferOperationBuilder(super=" + super.toString() + ", selling=" + this.selling + ", buying=" + this.buying + ", amount=" + this.amount + ", price=" + this.price + ")";
        }
    }
}

