/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Price;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.ManageSellOfferOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ManageSellOfferOperation
extends Operation {
    @NonNull
    private final Asset selling;
    @NonNull
    private final Asset buying;
    @NonNull
    private final BigDecimal amount;
    @NonNull
    private final Price price;
    private final long offerId;

    public static ManageSellOfferOperation fromXdr(ManageSellOfferOp op) {
        Asset selling = Asset.fromXdr(op.getSelling());
        Asset buying = Asset.fromXdr(op.getBuying());
        BigDecimal amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        Price price = Price.fromXdr(op.getPrice());
        long offerId = op.getOfferID().getInt64();
        return new ManageSellOfferOperation(selling, buying, amount, price, offerId);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ManageSellOfferOp op = new ManageSellOfferOp();
        op.setSelling(this.selling.toXdr());
        op.setBuying(this.buying.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        op.setPrice(this.price.toXdr());
        Int64 offerId = new Int64();
        offerId.setInt64(this.offerId);
        op.setOfferID(offerId);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.MANAGE_SELL_OFFER);
        body.setManageSellOfferOp(op);
        return body;
    }

    @Generated
    protected ManageSellOfferOperation(ManageSellOfferOperationBuilder<?, ?> b) {
        super(b);
        this.selling = ((ManageSellOfferOperationBuilder)b).selling;
        if (this.selling == null) {
            throw new NullPointerException("selling is marked non-null but is null");
        }
        this.buying = ((ManageSellOfferOperationBuilder)b).buying;
        if (this.buying == null) {
            throw new NullPointerException("buying is marked non-null but is null");
        }
        this.amount = ((ManageSellOfferOperationBuilder)b).amount;
        if (this.amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.price = ((ManageSellOfferOperationBuilder)b).price;
        if (this.price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        this.offerId = ((ManageSellOfferOperationBuilder)b).offerId;
    }

    @Generated
    public static ManageSellOfferOperationBuilder<?, ?> builder() {
        return new ManageSellOfferOperationBuilderImpl();
    }

    @Generated
    public ManageSellOfferOperationBuilder<?, ?> toBuilder() {
        return new ManageSellOfferOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public Asset getSelling() {
        return this.selling;
    }

    @NonNull
    @Generated
    public Asset getBuying() {
        return this.buying;
    }

    @NonNull
    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public Price getPrice() {
        return this.price;
    }

    @Generated
    public long getOfferId() {
        return this.offerId;
    }

    @Generated
    public String toString() {
        return "ManageSellOfferOperation(super=" + super.toString() + ", selling=" + this.getSelling() + ", buying=" + this.getBuying() + ", amount=" + this.getAmount() + ", price=" + this.getPrice() + ", offerId=" + this.getOfferId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManageSellOfferOperation)) {
            return false;
        }
        ManageSellOfferOperation other = (ManageSellOfferOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getOfferId() != other.getOfferId()) {
            return false;
        }
        Asset this$selling = this.getSelling();
        Asset other$selling = other.getSelling();
        if (this$selling == null ? other$selling != null : !((Object)this$selling).equals(other$selling)) {
            return false;
        }
        Asset this$buying = this.getBuying();
        Asset other$buying = other.getBuying();
        if (this$buying == null ? other$buying != null : !((Object)this$buying).equals(other$buying)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Price this$price = this.getPrice();
        Price other$price = other.getPrice();
        return !(this$price == null ? other$price != null : !((Object)this$price).equals(other$price));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManageSellOfferOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $offerId = this.getOfferId();
        result = result * 59 + (int)($offerId >>> 32 ^ $offerId);
        Asset $selling = this.getSelling();
        result = result * 59 + ($selling == null ? 43 : $selling.hashCode());
        Asset $buying = this.getBuying();
        result = result * 59 + ($buying == null ? 43 : $buying.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Price $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        return result;
    }

    @Generated
    private ManageSellOfferOperation(@NonNull Asset selling, @NonNull Asset buying, @NonNull BigDecimal amount, @NonNull Price price, long offerId) {
        if (selling == null) {
            throw new NullPointerException("selling is marked non-null but is null");
        }
        if (buying == null) {
            throw new NullPointerException("buying is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        this.selling = selling;
        this.buying = buying;
        this.amount = amount;
        this.price = price;
        this.offerId = offerId;
    }

    @Generated
    private static final class ManageSellOfferOperationBuilderImpl
    extends ManageSellOfferOperationBuilder<ManageSellOfferOperation, ManageSellOfferOperationBuilderImpl> {
        @Generated
        private ManageSellOfferOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected ManageSellOfferOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ManageSellOfferOperation build() {
            return new ManageSellOfferOperation(this);
        }
    }

    public static abstract class ManageSellOfferOperationBuilder<C extends ManageSellOfferOperation, B extends ManageSellOfferOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private Asset selling;
        @Generated
        private Asset buying;
        @Generated
        private BigDecimal amount;
        @Generated
        private Price price;
        @Generated
        private long offerId;

        public B amount(@NonNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = Operation.formatAmountScale(amount);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ManageSellOfferOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ManageSellOfferOperation instance, ManageSellOfferOperationBuilder<?, ?> b) {
            b.selling(instance.selling);
            b.buying(instance.buying);
            b.amount(instance.amount);
            b.price(instance.price);
            b.offerId(instance.offerId);
        }

        @Generated
        public B selling(@NonNull Asset selling) {
            if (selling == null) {
                throw new NullPointerException("selling is marked non-null but is null");
            }
            this.selling = selling;
            return (B)this.self();
        }

        @Generated
        public B buying(@NonNull Asset buying) {
            if (buying == null) {
                throw new NullPointerException("buying is marked non-null but is null");
            }
            this.buying = buying;
            return (B)this.self();
        }

        @Generated
        public B price(@NonNull Price price) {
            if (price == null) {
                throw new NullPointerException("price is marked non-null but is null");
            }
            this.price = price;
            return (B)this.self();
        }

        @Generated
        public B offerId(long offerId) {
            this.offerId = offerId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ManageSellOfferOperation.ManageSellOfferOperationBuilder(super=" + super.toString() + ", selling=" + this.selling + ", buying=" + this.buying + ", amount=" + this.amount + ", price=" + this.price + ", offerId=" + this.offerId + ")";
        }
    }
}

