/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.HmacSha256Mac;
import org.stellar.sdk.xdr.StellarMessage;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AuthenticatedMessage
implements XdrElement {
    private Uint32 discriminant;
    private AuthenticatedMessageV0 v0;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getUint32().getNumber().intValue());
        switch (this.discriminant.getUint32().getNumber().intValue()) {
            case 0: {
                this.v0.encode(stream);
            }
        }
    }

    public static AuthenticatedMessage decode(XdrDataInputStream stream) throws IOException {
        AuthenticatedMessage decodedAuthenticatedMessage = new AuthenticatedMessage();
        Uint32 discriminant = Uint32.decode(stream);
        decodedAuthenticatedMessage.setDiscriminant(discriminant);
        switch (decodedAuthenticatedMessage.getDiscriminant().getUint32().getNumber().intValue()) {
            case 0: {
                decodedAuthenticatedMessage.v0 = AuthenticatedMessageV0.decode(stream);
            }
        }
        return decodedAuthenticatedMessage;
    }

    public static AuthenticatedMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AuthenticatedMessage.fromXdrByteArray(bytes);
    }

    public static AuthenticatedMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AuthenticatedMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static AuthenticatedMessageBuilder builder() {
        return new AuthenticatedMessageBuilder();
    }

    @Generated
    public AuthenticatedMessageBuilder toBuilder() {
        return new AuthenticatedMessageBuilder().discriminant(this.discriminant).v0(this.v0);
    }

    @Generated
    public Uint32 getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public AuthenticatedMessageV0 getV0() {
        return this.v0;
    }

    @Generated
    public void setDiscriminant(Uint32 discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setV0(AuthenticatedMessageV0 v0) {
        this.v0 = v0;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatedMessage)) {
            return false;
        }
        AuthenticatedMessage other = (AuthenticatedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$discriminant = this.getDiscriminant();
        Uint32 other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
            return false;
        }
        AuthenticatedMessageV0 this$v0 = this.getV0();
        AuthenticatedMessageV0 other$v0 = other.getV0();
        return !(this$v0 == null ? other$v0 != null : !((Object)this$v0).equals(other$v0));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticatedMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
        AuthenticatedMessageV0 $v0 = this.getV0();
        result = result * 59 + ($v0 == null ? 43 : ((Object)$v0).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatedMessage(discriminant=" + this.getDiscriminant() + ", v0=" + this.getV0() + ")";
    }

    @Generated
    public AuthenticatedMessage() {
    }

    @Generated
    public AuthenticatedMessage(Uint32 discriminant, AuthenticatedMessageV0 v0) {
        this.discriminant = discriminant;
        this.v0 = v0;
    }

    @Generated
    public static class AuthenticatedMessageBuilder {
        @Generated
        private Uint32 discriminant;
        @Generated
        private AuthenticatedMessageV0 v0;

        @Generated
        AuthenticatedMessageBuilder() {
        }

        @Generated
        public AuthenticatedMessageBuilder discriminant(Uint32 discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public AuthenticatedMessageBuilder v0(AuthenticatedMessageV0 v0) {
            this.v0 = v0;
            return this;
        }

        @Generated
        public AuthenticatedMessage build() {
            return new AuthenticatedMessage(this.discriminant, this.v0);
        }

        @Generated
        public String toString() {
            return "AuthenticatedMessage.AuthenticatedMessageBuilder(discriminant=" + this.discriminant + ", v0=" + this.v0 + ")";
        }
    }

    public static class AuthenticatedMessageV0
    implements XdrElement {
        private Uint64 sequence;
        private StellarMessage message;
        private HmacSha256Mac mac;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.sequence.encode(stream);
            this.message.encode(stream);
            this.mac.encode(stream);
        }

        public static AuthenticatedMessageV0 decode(XdrDataInputStream stream) throws IOException {
            AuthenticatedMessageV0 decodedAuthenticatedMessageV0 = new AuthenticatedMessageV0();
            decodedAuthenticatedMessageV0.sequence = Uint64.decode(stream);
            decodedAuthenticatedMessageV0.message = StellarMessage.decode(stream);
            decodedAuthenticatedMessageV0.mac = HmacSha256Mac.decode(stream);
            return decodedAuthenticatedMessageV0;
        }

        public static AuthenticatedMessageV0 fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return AuthenticatedMessageV0.fromXdrByteArray(bytes);
        }

        public static AuthenticatedMessageV0 fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return AuthenticatedMessageV0.decode(xdrDataInputStream);
        }

        @Generated
        public static AuthenticatedMessageV0Builder builder() {
            return new AuthenticatedMessageV0Builder();
        }

        @Generated
        public AuthenticatedMessageV0Builder toBuilder() {
            return new AuthenticatedMessageV0Builder().sequence(this.sequence).message(this.message).mac(this.mac);
        }

        @Generated
        public Uint64 getSequence() {
            return this.sequence;
        }

        @Generated
        public StellarMessage getMessage() {
            return this.message;
        }

        @Generated
        public HmacSha256Mac getMac() {
            return this.mac;
        }

        @Generated
        public void setSequence(Uint64 sequence2) {
            this.sequence = sequence2;
        }

        @Generated
        public void setMessage(StellarMessage message) {
            this.message = message;
        }

        @Generated
        public void setMac(HmacSha256Mac mac) {
            this.mac = mac;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthenticatedMessageV0)) {
                return false;
            }
            AuthenticatedMessageV0 other = (AuthenticatedMessageV0)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Uint64 this$sequence = this.getSequence();
            Uint64 other$sequence = other.getSequence();
            if (this$sequence == null ? other$sequence != null : !((Object)this$sequence).equals(other$sequence)) {
                return false;
            }
            StellarMessage this$message = this.getMessage();
            StellarMessage other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            HmacSha256Mac this$mac = this.getMac();
            HmacSha256Mac other$mac = other.getMac();
            return !(this$mac == null ? other$mac != null : !((Object)this$mac).equals(other$mac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthenticatedMessageV0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Uint64 $sequence = this.getSequence();
            result = result * 59 + ($sequence == null ? 43 : ((Object)$sequence).hashCode());
            StellarMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            HmacSha256Mac $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : ((Object)$mac).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthenticatedMessage.AuthenticatedMessageV0(sequence=" + this.getSequence() + ", message=" + this.getMessage() + ", mac=" + this.getMac() + ")";
        }

        @Generated
        public AuthenticatedMessageV0() {
        }

        @Generated
        public AuthenticatedMessageV0(Uint64 sequence2, StellarMessage message, HmacSha256Mac mac) {
            this.sequence = sequence2;
            this.message = message;
            this.mac = mac;
        }

        @Generated
        public static class AuthenticatedMessageV0Builder {
            @Generated
            private Uint64 sequence;
            @Generated
            private StellarMessage message;
            @Generated
            private HmacSha256Mac mac;

            @Generated
            AuthenticatedMessageV0Builder() {
            }

            @Generated
            public AuthenticatedMessageV0Builder sequence(Uint64 sequence2) {
                this.sequence = sequence2;
                return this;
            }

            @Generated
            public AuthenticatedMessageV0Builder message(StellarMessage message) {
                this.message = message;
                return this;
            }

            @Generated
            public AuthenticatedMessageV0Builder mac(HmacSha256Mac mac) {
                this.mac = mac;
                return this;
            }

            @Generated
            public AuthenticatedMessageV0 build() {
                return new AuthenticatedMessageV0(this.sequence, this.message, this.mac);
            }

            @Generated
            public String toString() {
                return "AuthenticatedMessage.AuthenticatedMessageV0.AuthenticatedMessageV0Builder(sequence=" + this.sequence + ", message=" + this.message + ", mac=" + this.mac + ")";
            }
        }
    }
}

