/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ConfigSettingEntry;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ConfigUpgradeSet
implements XdrElement {
    private ConfigSettingEntry[] updatedEntry;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int updatedEntrySize = this.getUpdatedEntry().length;
        stream.writeInt(updatedEntrySize);
        for (int i = 0; i < updatedEntrySize; ++i) {
            this.updatedEntry[i].encode(stream);
        }
    }

    public static ConfigUpgradeSet decode(XdrDataInputStream stream) throws IOException {
        ConfigUpgradeSet decodedConfigUpgradeSet = new ConfigUpgradeSet();
        int updatedEntrySize = stream.readInt();
        decodedConfigUpgradeSet.updatedEntry = new ConfigSettingEntry[updatedEntrySize];
        for (int i = 0; i < updatedEntrySize; ++i) {
            decodedConfigUpgradeSet.updatedEntry[i] = ConfigSettingEntry.decode(stream);
        }
        return decodedConfigUpgradeSet;
    }

    public static ConfigUpgradeSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ConfigUpgradeSet.fromXdrByteArray(bytes);
    }

    public static ConfigUpgradeSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ConfigUpgradeSet.decode(xdrDataInputStream);
    }

    @Generated
    public static ConfigUpgradeSetBuilder builder() {
        return new ConfigUpgradeSetBuilder();
    }

    @Generated
    public ConfigUpgradeSetBuilder toBuilder() {
        return new ConfigUpgradeSetBuilder().updatedEntry(this.updatedEntry);
    }

    @Generated
    public ConfigSettingEntry[] getUpdatedEntry() {
        return this.updatedEntry;
    }

    @Generated
    public void setUpdatedEntry(ConfigSettingEntry[] updatedEntry) {
        this.updatedEntry = updatedEntry;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigUpgradeSet)) {
            return false;
        }
        ConfigUpgradeSet other = (ConfigUpgradeSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getUpdatedEntry(), other.getUpdatedEntry());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigUpgradeSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getUpdatedEntry());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigUpgradeSet(updatedEntry=" + Arrays.deepToString(this.getUpdatedEntry()) + ")";
    }

    @Generated
    public ConfigUpgradeSet() {
    }

    @Generated
    public ConfigUpgradeSet(ConfigSettingEntry[] updatedEntry) {
        this.updatedEntry = updatedEntry;
    }

    @Generated
    public static class ConfigUpgradeSetBuilder {
        @Generated
        private ConfigSettingEntry[] updatedEntry;

        @Generated
        ConfigUpgradeSetBuilder() {
        }

        @Generated
        public ConfigUpgradeSetBuilder updatedEntry(ConfigSettingEntry[] updatedEntry) {
            this.updatedEntry = updatedEntry;
            return this;
        }

        @Generated
        public ConfigUpgradeSet build() {
            return new ConfigUpgradeSet(this.updatedEntry);
        }

        @Generated
        public String toString() {
            return "ConfigUpgradeSet.ConfigUpgradeSetBuilder(updatedEntry=" + Arrays.deepToString(this.updatedEntry) + ")";
        }
    }
}

