/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountEntry;
import org.stellar.sdk.xdr.ClaimableBalanceEntry;
import org.stellar.sdk.xdr.ConfigSettingEntry;
import org.stellar.sdk.xdr.ContractCodeEntry;
import org.stellar.sdk.xdr.ContractDataEntry;
import org.stellar.sdk.xdr.DataEntry;
import org.stellar.sdk.xdr.LedgerEntryExtensionV1;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LiquidityPoolEntry;
import org.stellar.sdk.xdr.OfferEntry;
import org.stellar.sdk.xdr.TTLEntry;
import org.stellar.sdk.xdr.TrustLineEntry;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerEntry
implements XdrElement {
    private Uint32 lastModifiedLedgerSeq;
    private LedgerEntryData data;
    private LedgerEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.lastModifiedLedgerSeq.encode(stream);
        this.data.encode(stream);
        this.ext.encode(stream);
    }

    public static LedgerEntry decode(XdrDataInputStream stream) throws IOException {
        LedgerEntry decodedLedgerEntry = new LedgerEntry();
        decodedLedgerEntry.lastModifiedLedgerSeq = Uint32.decode(stream);
        decodedLedgerEntry.data = LedgerEntryData.decode(stream);
        decodedLedgerEntry.ext = LedgerEntryExt.decode(stream);
        return decodedLedgerEntry;
    }

    public static LedgerEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerEntry.fromXdrByteArray(bytes);
    }

    public static LedgerEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerEntryBuilder builder() {
        return new LedgerEntryBuilder();
    }

    @Generated
    public LedgerEntryBuilder toBuilder() {
        return new LedgerEntryBuilder().lastModifiedLedgerSeq(this.lastModifiedLedgerSeq).data(this.data).ext(this.ext);
    }

    @Generated
    public Uint32 getLastModifiedLedgerSeq() {
        return this.lastModifiedLedgerSeq;
    }

    @Generated
    public LedgerEntryData getData() {
        return this.data;
    }

    @Generated
    public LedgerEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setLastModifiedLedgerSeq(Uint32 lastModifiedLedgerSeq) {
        this.lastModifiedLedgerSeq = lastModifiedLedgerSeq;
    }

    @Generated
    public void setData(LedgerEntryData data) {
        this.data = data;
    }

    @Generated
    public void setExt(LedgerEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerEntry)) {
            return false;
        }
        LedgerEntry other = (LedgerEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$lastModifiedLedgerSeq = this.getLastModifiedLedgerSeq();
        Uint32 other$lastModifiedLedgerSeq = other.getLastModifiedLedgerSeq();
        if (this$lastModifiedLedgerSeq == null ? other$lastModifiedLedgerSeq != null : !((Object)this$lastModifiedLedgerSeq).equals(other$lastModifiedLedgerSeq)) {
            return false;
        }
        LedgerEntryData this$data = this.getData();
        LedgerEntryData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        LedgerEntryExt this$ext = this.getExt();
        LedgerEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $lastModifiedLedgerSeq = this.getLastModifiedLedgerSeq();
        result = result * 59 + ($lastModifiedLedgerSeq == null ? 43 : ((Object)$lastModifiedLedgerSeq).hashCode());
        LedgerEntryData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        LedgerEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerEntry(lastModifiedLedgerSeq=" + this.getLastModifiedLedgerSeq() + ", data=" + this.getData() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public LedgerEntry() {
    }

    @Generated
    public LedgerEntry(Uint32 lastModifiedLedgerSeq, LedgerEntryData data, LedgerEntryExt ext) {
        this.lastModifiedLedgerSeq = lastModifiedLedgerSeq;
        this.data = data;
        this.ext = ext;
    }

    @Generated
    public static class LedgerEntryBuilder {
        @Generated
        private Uint32 lastModifiedLedgerSeq;
        @Generated
        private LedgerEntryData data;
        @Generated
        private LedgerEntryExt ext;

        @Generated
        LedgerEntryBuilder() {
        }

        @Generated
        public LedgerEntryBuilder lastModifiedLedgerSeq(Uint32 lastModifiedLedgerSeq) {
            this.lastModifiedLedgerSeq = lastModifiedLedgerSeq;
            return this;
        }

        @Generated
        public LedgerEntryBuilder data(LedgerEntryData data) {
            this.data = data;
            return this;
        }

        @Generated
        public LedgerEntryBuilder ext(LedgerEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public LedgerEntry build() {
            return new LedgerEntry(this.lastModifiedLedgerSeq, this.data, this.ext);
        }

        @Generated
        public String toString() {
            return "LedgerEntry.LedgerEntryBuilder(lastModifiedLedgerSeq=" + this.lastModifiedLedgerSeq + ", data=" + this.data + ", ext=" + this.ext + ")";
        }
    }

    public static class LedgerEntryExt
    implements XdrElement {
        private Integer discriminant;
        private LedgerEntryExtensionV1 v1;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.v1.encode(stream);
                }
            }
        }

        public static LedgerEntryExt decode(XdrDataInputStream stream) throws IOException {
            LedgerEntryExt decodedLedgerEntryExt = new LedgerEntryExt();
            Integer discriminant = stream.readInt();
            decodedLedgerEntryExt.setDiscriminant(discriminant);
            switch (decodedLedgerEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedLedgerEntryExt.v1 = LedgerEntryExtensionV1.decode(stream);
                }
            }
            return decodedLedgerEntryExt;
        }

        public static LedgerEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerEntryExt.fromXdrByteArray(bytes);
        }

        public static LedgerEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerEntryExtBuilder builder() {
            return new LedgerEntryExtBuilder();
        }

        @Generated
        public LedgerEntryExtBuilder toBuilder() {
            return new LedgerEntryExtBuilder().discriminant(this.discriminant).v1(this.v1);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public LedgerEntryExtensionV1 getV1() {
            return this.v1;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV1(LedgerEntryExtensionV1 v1) {
            this.v1 = v1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerEntryExt)) {
                return false;
            }
            LedgerEntryExt other = (LedgerEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            LedgerEntryExtensionV1 this$v1 = this.getV1();
            LedgerEntryExtensionV1 other$v1 = other.getV1();
            return !(this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            LedgerEntryExtensionV1 $v1 = this.getV1();
            result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerEntry.LedgerEntryExt(discriminant=" + this.getDiscriminant() + ", v1=" + this.getV1() + ")";
        }

        @Generated
        public LedgerEntryExt() {
        }

        @Generated
        public LedgerEntryExt(Integer discriminant, LedgerEntryExtensionV1 v1) {
            this.discriminant = discriminant;
            this.v1 = v1;
        }

        @Generated
        public static class LedgerEntryExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private LedgerEntryExtensionV1 v1;

            @Generated
            LedgerEntryExtBuilder() {
            }

            @Generated
            public LedgerEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public LedgerEntryExtBuilder v1(LedgerEntryExtensionV1 v1) {
                this.v1 = v1;
                return this;
            }

            @Generated
            public LedgerEntryExt build() {
                return new LedgerEntryExt(this.discriminant, this.v1);
            }

            @Generated
            public String toString() {
                return "LedgerEntry.LedgerEntryExt.LedgerEntryExtBuilder(discriminant=" + this.discriminant + ", v1=" + this.v1 + ")";
            }
        }
    }

    public static class LedgerEntryData
    implements XdrElement {
        private LedgerEntryType discriminant;
        private AccountEntry account;
        private TrustLineEntry trustLine;
        private OfferEntry offer;
        private DataEntry data;
        private ClaimableBalanceEntry claimableBalance;
        private LiquidityPoolEntry liquidityPool;
        private ContractDataEntry contractData;
        private ContractCodeEntry contractCode;
        private ConfigSettingEntry configSetting;
        private TTLEntry ttl;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case ACCOUNT: {
                    this.account.encode(stream);
                    break;
                }
                case TRUSTLINE: {
                    this.trustLine.encode(stream);
                    break;
                }
                case OFFER: {
                    this.offer.encode(stream);
                    break;
                }
                case DATA: {
                    this.data.encode(stream);
                    break;
                }
                case CLAIMABLE_BALANCE: {
                    this.claimableBalance.encode(stream);
                    break;
                }
                case LIQUIDITY_POOL: {
                    this.liquidityPool.encode(stream);
                    break;
                }
                case CONTRACT_DATA: {
                    this.contractData.encode(stream);
                    break;
                }
                case CONTRACT_CODE: {
                    this.contractCode.encode(stream);
                    break;
                }
                case CONFIG_SETTING: {
                    this.configSetting.encode(stream);
                    break;
                }
                case TTL: {
                    this.ttl.encode(stream);
                }
            }
        }

        public static LedgerEntryData decode(XdrDataInputStream stream) throws IOException {
            LedgerEntryData decodedLedgerEntryData = new LedgerEntryData();
            LedgerEntryType discriminant = LedgerEntryType.decode(stream);
            decodedLedgerEntryData.setDiscriminant(discriminant);
            switch (decodedLedgerEntryData.getDiscriminant()) {
                case ACCOUNT: {
                    decodedLedgerEntryData.account = AccountEntry.decode(stream);
                    break;
                }
                case TRUSTLINE: {
                    decodedLedgerEntryData.trustLine = TrustLineEntry.decode(stream);
                    break;
                }
                case OFFER: {
                    decodedLedgerEntryData.offer = OfferEntry.decode(stream);
                    break;
                }
                case DATA: {
                    decodedLedgerEntryData.data = DataEntry.decode(stream);
                    break;
                }
                case CLAIMABLE_BALANCE: {
                    decodedLedgerEntryData.claimableBalance = ClaimableBalanceEntry.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL: {
                    decodedLedgerEntryData.liquidityPool = LiquidityPoolEntry.decode(stream);
                    break;
                }
                case CONTRACT_DATA: {
                    decodedLedgerEntryData.contractData = ContractDataEntry.decode(stream);
                    break;
                }
                case CONTRACT_CODE: {
                    decodedLedgerEntryData.contractCode = ContractCodeEntry.decode(stream);
                    break;
                }
                case CONFIG_SETTING: {
                    decodedLedgerEntryData.configSetting = ConfigSettingEntry.decode(stream);
                    break;
                }
                case TTL: {
                    decodedLedgerEntryData.ttl = TTLEntry.decode(stream);
                }
            }
            return decodedLedgerEntryData;
        }

        public static LedgerEntryData fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerEntryData.fromXdrByteArray(bytes);
        }

        public static LedgerEntryData fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerEntryData.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerEntryDataBuilder builder() {
            return new LedgerEntryDataBuilder();
        }

        @Generated
        public LedgerEntryDataBuilder toBuilder() {
            return new LedgerEntryDataBuilder().discriminant(this.discriminant).account(this.account).trustLine(this.trustLine).offer(this.offer).data(this.data).claimableBalance(this.claimableBalance).liquidityPool(this.liquidityPool).contractData(this.contractData).contractCode(this.contractCode).configSetting(this.configSetting).ttl(this.ttl);
        }

        @Generated
        public LedgerEntryType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public AccountEntry getAccount() {
            return this.account;
        }

        @Generated
        public TrustLineEntry getTrustLine() {
            return this.trustLine;
        }

        @Generated
        public OfferEntry getOffer() {
            return this.offer;
        }

        @Generated
        public DataEntry getData() {
            return this.data;
        }

        @Generated
        public ClaimableBalanceEntry getClaimableBalance() {
            return this.claimableBalance;
        }

        @Generated
        public LiquidityPoolEntry getLiquidityPool() {
            return this.liquidityPool;
        }

        @Generated
        public ContractDataEntry getContractData() {
            return this.contractData;
        }

        @Generated
        public ContractCodeEntry getContractCode() {
            return this.contractCode;
        }

        @Generated
        public ConfigSettingEntry getConfigSetting() {
            return this.configSetting;
        }

        @Generated
        public TTLEntry getTtl() {
            return this.ttl;
        }

        @Generated
        public void setDiscriminant(LedgerEntryType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setAccount(AccountEntry account) {
            this.account = account;
        }

        @Generated
        public void setTrustLine(TrustLineEntry trustLine) {
            this.trustLine = trustLine;
        }

        @Generated
        public void setOffer(OfferEntry offer) {
            this.offer = offer;
        }

        @Generated
        public void setData(DataEntry data) {
            this.data = data;
        }

        @Generated
        public void setClaimableBalance(ClaimableBalanceEntry claimableBalance) {
            this.claimableBalance = claimableBalance;
        }

        @Generated
        public void setLiquidityPool(LiquidityPoolEntry liquidityPool) {
            this.liquidityPool = liquidityPool;
        }

        @Generated
        public void setContractData(ContractDataEntry contractData) {
            this.contractData = contractData;
        }

        @Generated
        public void setContractCode(ContractCodeEntry contractCode) {
            this.contractCode = contractCode;
        }

        @Generated
        public void setConfigSetting(ConfigSettingEntry configSetting) {
            this.configSetting = configSetting;
        }

        @Generated
        public void setTtl(TTLEntry ttl) {
            this.ttl = ttl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerEntryData)) {
                return false;
            }
            LedgerEntryData other = (LedgerEntryData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LedgerEntryType this$discriminant = this.getDiscriminant();
            LedgerEntryType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            AccountEntry this$account = this.getAccount();
            AccountEntry other$account = other.getAccount();
            if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
                return false;
            }
            TrustLineEntry this$trustLine = this.getTrustLine();
            TrustLineEntry other$trustLine = other.getTrustLine();
            if (this$trustLine == null ? other$trustLine != null : !((Object)this$trustLine).equals(other$trustLine)) {
                return false;
            }
            OfferEntry this$offer = this.getOffer();
            OfferEntry other$offer = other.getOffer();
            if (this$offer == null ? other$offer != null : !((Object)this$offer).equals(other$offer)) {
                return false;
            }
            DataEntry this$data = this.getData();
            DataEntry other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            ClaimableBalanceEntry this$claimableBalance = this.getClaimableBalance();
            ClaimableBalanceEntry other$claimableBalance = other.getClaimableBalance();
            if (this$claimableBalance == null ? other$claimableBalance != null : !((Object)this$claimableBalance).equals(other$claimableBalance)) {
                return false;
            }
            LiquidityPoolEntry this$liquidityPool = this.getLiquidityPool();
            LiquidityPoolEntry other$liquidityPool = other.getLiquidityPool();
            if (this$liquidityPool == null ? other$liquidityPool != null : !((Object)this$liquidityPool).equals(other$liquidityPool)) {
                return false;
            }
            ContractDataEntry this$contractData = this.getContractData();
            ContractDataEntry other$contractData = other.getContractData();
            if (this$contractData == null ? other$contractData != null : !((Object)this$contractData).equals(other$contractData)) {
                return false;
            }
            ContractCodeEntry this$contractCode = this.getContractCode();
            ContractCodeEntry other$contractCode = other.getContractCode();
            if (this$contractCode == null ? other$contractCode != null : !((Object)this$contractCode).equals(other$contractCode)) {
                return false;
            }
            ConfigSettingEntry this$configSetting = this.getConfigSetting();
            ConfigSettingEntry other$configSetting = other.getConfigSetting();
            if (this$configSetting == null ? other$configSetting != null : !((Object)this$configSetting).equals(other$configSetting)) {
                return false;
            }
            TTLEntry this$ttl = this.getTtl();
            TTLEntry other$ttl = other.getTtl();
            return !(this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerEntryData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LedgerEntryType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            AccountEntry $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
            TrustLineEntry $trustLine = this.getTrustLine();
            result = result * 59 + ($trustLine == null ? 43 : ((Object)$trustLine).hashCode());
            OfferEntry $offer = this.getOffer();
            result = result * 59 + ($offer == null ? 43 : ((Object)$offer).hashCode());
            DataEntry $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            ClaimableBalanceEntry $claimableBalance = this.getClaimableBalance();
            result = result * 59 + ($claimableBalance == null ? 43 : ((Object)$claimableBalance).hashCode());
            LiquidityPoolEntry $liquidityPool = this.getLiquidityPool();
            result = result * 59 + ($liquidityPool == null ? 43 : ((Object)$liquidityPool).hashCode());
            ContractDataEntry $contractData = this.getContractData();
            result = result * 59 + ($contractData == null ? 43 : ((Object)$contractData).hashCode());
            ContractCodeEntry $contractCode = this.getContractCode();
            result = result * 59 + ($contractCode == null ? 43 : ((Object)$contractCode).hashCode());
            ConfigSettingEntry $configSetting = this.getConfigSetting();
            result = result * 59 + ($configSetting == null ? 43 : ((Object)$configSetting).hashCode());
            TTLEntry $ttl = this.getTtl();
            result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerEntry.LedgerEntryData(discriminant=" + this.getDiscriminant() + ", account=" + this.getAccount() + ", trustLine=" + this.getTrustLine() + ", offer=" + this.getOffer() + ", data=" + this.getData() + ", claimableBalance=" + this.getClaimableBalance() + ", liquidityPool=" + this.getLiquidityPool() + ", contractData=" + this.getContractData() + ", contractCode=" + this.getContractCode() + ", configSetting=" + this.getConfigSetting() + ", ttl=" + this.getTtl() + ")";
        }

        @Generated
        public LedgerEntryData() {
        }

        @Generated
        public LedgerEntryData(LedgerEntryType discriminant, AccountEntry account, TrustLineEntry trustLine, OfferEntry offer, DataEntry data, ClaimableBalanceEntry claimableBalance, LiquidityPoolEntry liquidityPool, ContractDataEntry contractData, ContractCodeEntry contractCode, ConfigSettingEntry configSetting, TTLEntry ttl) {
            this.discriminant = discriminant;
            this.account = account;
            this.trustLine = trustLine;
            this.offer = offer;
            this.data = data;
            this.claimableBalance = claimableBalance;
            this.liquidityPool = liquidityPool;
            this.contractData = contractData;
            this.contractCode = contractCode;
            this.configSetting = configSetting;
            this.ttl = ttl;
        }

        @Generated
        public static class LedgerEntryDataBuilder {
            @Generated
            private LedgerEntryType discriminant;
            @Generated
            private AccountEntry account;
            @Generated
            private TrustLineEntry trustLine;
            @Generated
            private OfferEntry offer;
            @Generated
            private DataEntry data;
            @Generated
            private ClaimableBalanceEntry claimableBalance;
            @Generated
            private LiquidityPoolEntry liquidityPool;
            @Generated
            private ContractDataEntry contractData;
            @Generated
            private ContractCodeEntry contractCode;
            @Generated
            private ConfigSettingEntry configSetting;
            @Generated
            private TTLEntry ttl;

            @Generated
            LedgerEntryDataBuilder() {
            }

            @Generated
            public LedgerEntryDataBuilder discriminant(LedgerEntryType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder account(AccountEntry account) {
                this.account = account;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder trustLine(TrustLineEntry trustLine) {
                this.trustLine = trustLine;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder offer(OfferEntry offer) {
                this.offer = offer;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder data(DataEntry data) {
                this.data = data;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder claimableBalance(ClaimableBalanceEntry claimableBalance) {
                this.claimableBalance = claimableBalance;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder liquidityPool(LiquidityPoolEntry liquidityPool) {
                this.liquidityPool = liquidityPool;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder contractData(ContractDataEntry contractData) {
                this.contractData = contractData;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder contractCode(ContractCodeEntry contractCode) {
                this.contractCode = contractCode;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder configSetting(ConfigSettingEntry configSetting) {
                this.configSetting = configSetting;
                return this;
            }

            @Generated
            public LedgerEntryDataBuilder ttl(TTLEntry ttl) {
                this.ttl = ttl;
                return this;
            }

            @Generated
            public LedgerEntryData build() {
                return new LedgerEntryData(this.discriminant, this.account, this.trustLine, this.offer, this.data, this.claimableBalance, this.liquidityPool, this.contractData, this.contractCode, this.configSetting, this.ttl);
            }

            @Generated
            public String toString() {
                return "LedgerEntry.LedgerEntryData.LedgerEntryDataBuilder(discriminant=" + this.discriminant + ", account=" + this.account + ", trustLine=" + this.trustLine + ", offer=" + this.offer + ", data=" + this.data + ", claimableBalance=" + this.claimableBalance + ", liquidityPool=" + this.liquidityPool + ", contractData=" + this.contractData + ", contractCode=" + this.contractCode + ", configSetting=" + this.configSetting + ", ttl=" + this.ttl + ")";
            }
        }
    }
}

