/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCEnvMetaKind;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCEnvMetaEntry
implements XdrElement {
    private SCEnvMetaKind discriminant;
    private SCEnvMetaEntryInterfaceVersion interfaceVersion;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SC_ENV_META_KIND_INTERFACE_VERSION: {
                this.interfaceVersion.encode(stream);
            }
        }
    }

    public static SCEnvMetaEntry decode(XdrDataInputStream stream) throws IOException {
        SCEnvMetaEntry decodedSCEnvMetaEntry = new SCEnvMetaEntry();
        SCEnvMetaKind discriminant = SCEnvMetaKind.decode(stream);
        decodedSCEnvMetaEntry.setDiscriminant(discriminant);
        switch (decodedSCEnvMetaEntry.getDiscriminant()) {
            case SC_ENV_META_KIND_INTERFACE_VERSION: {
                decodedSCEnvMetaEntry.interfaceVersion = SCEnvMetaEntryInterfaceVersion.decode(stream);
            }
        }
        return decodedSCEnvMetaEntry;
    }

    public static SCEnvMetaEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCEnvMetaEntry.fromXdrByteArray(bytes);
    }

    public static SCEnvMetaEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCEnvMetaEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static SCEnvMetaEntryBuilder builder() {
        return new SCEnvMetaEntryBuilder();
    }

    @Generated
    public SCEnvMetaEntryBuilder toBuilder() {
        return new SCEnvMetaEntryBuilder().discriminant(this.discriminant).interfaceVersion(this.interfaceVersion);
    }

    @Generated
    public SCEnvMetaKind getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public SCEnvMetaEntryInterfaceVersion getInterfaceVersion() {
        return this.interfaceVersion;
    }

    @Generated
    public void setDiscriminant(SCEnvMetaKind discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setInterfaceVersion(SCEnvMetaEntryInterfaceVersion interfaceVersion) {
        this.interfaceVersion = interfaceVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCEnvMetaEntry)) {
            return false;
        }
        SCEnvMetaEntry other = (SCEnvMetaEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCEnvMetaKind this$discriminant = this.getDiscriminant();
        SCEnvMetaKind other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        SCEnvMetaEntryInterfaceVersion this$interfaceVersion = this.getInterfaceVersion();
        SCEnvMetaEntryInterfaceVersion other$interfaceVersion = other.getInterfaceVersion();
        return !(this$interfaceVersion == null ? other$interfaceVersion != null : !((Object)this$interfaceVersion).equals(other$interfaceVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCEnvMetaEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCEnvMetaKind $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        SCEnvMetaEntryInterfaceVersion $interfaceVersion = this.getInterfaceVersion();
        result = result * 59 + ($interfaceVersion == null ? 43 : ((Object)$interfaceVersion).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCEnvMetaEntry(discriminant=" + this.getDiscriminant() + ", interfaceVersion=" + this.getInterfaceVersion() + ")";
    }

    @Generated
    public SCEnvMetaEntry() {
    }

    @Generated
    public SCEnvMetaEntry(SCEnvMetaKind discriminant, SCEnvMetaEntryInterfaceVersion interfaceVersion) {
        this.discriminant = discriminant;
        this.interfaceVersion = interfaceVersion;
    }

    @Generated
    public static class SCEnvMetaEntryBuilder {
        @Generated
        private SCEnvMetaKind discriminant;
        @Generated
        private SCEnvMetaEntryInterfaceVersion interfaceVersion;

        @Generated
        SCEnvMetaEntryBuilder() {
        }

        @Generated
        public SCEnvMetaEntryBuilder discriminant(SCEnvMetaKind discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCEnvMetaEntryBuilder interfaceVersion(SCEnvMetaEntryInterfaceVersion interfaceVersion) {
            this.interfaceVersion = interfaceVersion;
            return this;
        }

        @Generated
        public SCEnvMetaEntry build() {
            return new SCEnvMetaEntry(this.discriminant, this.interfaceVersion);
        }

        @Generated
        public String toString() {
            return "SCEnvMetaEntry.SCEnvMetaEntryBuilder(discriminant=" + this.discriminant + ", interfaceVersion=" + this.interfaceVersion + ")";
        }
    }

    public static class SCEnvMetaEntryInterfaceVersion
    implements XdrElement {
        private Uint32 protocol;
        private Uint32 preRelease;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.protocol.encode(stream);
            this.preRelease.encode(stream);
        }

        public static SCEnvMetaEntryInterfaceVersion decode(XdrDataInputStream stream) throws IOException {
            SCEnvMetaEntryInterfaceVersion decodedSCEnvMetaEntryInterfaceVersion = new SCEnvMetaEntryInterfaceVersion();
            decodedSCEnvMetaEntryInterfaceVersion.protocol = Uint32.decode(stream);
            decodedSCEnvMetaEntryInterfaceVersion.preRelease = Uint32.decode(stream);
            return decodedSCEnvMetaEntryInterfaceVersion;
        }

        public static SCEnvMetaEntryInterfaceVersion fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return SCEnvMetaEntryInterfaceVersion.fromXdrByteArray(bytes);
        }

        public static SCEnvMetaEntryInterfaceVersion fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return SCEnvMetaEntryInterfaceVersion.decode(xdrDataInputStream);
        }

        @Generated
        public static SCEnvMetaEntryInterfaceVersionBuilder builder() {
            return new SCEnvMetaEntryInterfaceVersionBuilder();
        }

        @Generated
        public SCEnvMetaEntryInterfaceVersionBuilder toBuilder() {
            return new SCEnvMetaEntryInterfaceVersionBuilder().protocol(this.protocol).preRelease(this.preRelease);
        }

        @Generated
        public Uint32 getProtocol() {
            return this.protocol;
        }

        @Generated
        public Uint32 getPreRelease() {
            return this.preRelease;
        }

        @Generated
        public void setProtocol(Uint32 protocol) {
            this.protocol = protocol;
        }

        @Generated
        public void setPreRelease(Uint32 preRelease) {
            this.preRelease = preRelease;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SCEnvMetaEntryInterfaceVersion)) {
                return false;
            }
            SCEnvMetaEntryInterfaceVersion other = (SCEnvMetaEntryInterfaceVersion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Uint32 this$protocol = this.getProtocol();
            Uint32 other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !((Object)this$protocol).equals(other$protocol)) {
                return false;
            }
            Uint32 this$preRelease = this.getPreRelease();
            Uint32 other$preRelease = other.getPreRelease();
            return !(this$preRelease == null ? other$preRelease != null : !((Object)this$preRelease).equals(other$preRelease));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SCEnvMetaEntryInterfaceVersion;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Uint32 $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : ((Object)$protocol).hashCode());
            Uint32 $preRelease = this.getPreRelease();
            result = result * 59 + ($preRelease == null ? 43 : ((Object)$preRelease).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SCEnvMetaEntry.SCEnvMetaEntryInterfaceVersion(protocol=" + this.getProtocol() + ", preRelease=" + this.getPreRelease() + ")";
        }

        @Generated
        public SCEnvMetaEntryInterfaceVersion() {
        }

        @Generated
        public SCEnvMetaEntryInterfaceVersion(Uint32 protocol, Uint32 preRelease) {
            this.protocol = protocol;
            this.preRelease = preRelease;
        }

        @Generated
        public static class SCEnvMetaEntryInterfaceVersionBuilder {
            @Generated
            private Uint32 protocol;
            @Generated
            private Uint32 preRelease;

            @Generated
            SCEnvMetaEntryInterfaceVersionBuilder() {
            }

            @Generated
            public SCEnvMetaEntryInterfaceVersionBuilder protocol(Uint32 protocol) {
                this.protocol = protocol;
                return this;
            }

            @Generated
            public SCEnvMetaEntryInterfaceVersionBuilder preRelease(Uint32 preRelease) {
                this.preRelease = preRelease;
                return this;
            }

            @Generated
            public SCEnvMetaEntryInterfaceVersion build() {
                return new SCEnvMetaEntryInterfaceVersion(this.protocol, this.preRelease);
            }

            @Generated
            public String toString() {
                return "SCEnvMetaEntry.SCEnvMetaEntryInterfaceVersion.SCEnvMetaEntryInterfaceVersionBuilder(protocol=" + this.protocol + ", preRelease=" + this.preRelease + ")";
            }
        }
    }
}

