/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.DiagnosticEvent;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.OperationMetaV2;
import org.stellar.sdk.xdr.SorobanTransactionMetaV2;
import org.stellar.sdk.xdr.TransactionEvent;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionMetaV4
implements XdrElement {
    private ExtensionPoint ext;
    private LedgerEntryChanges txChangesBefore;
    private OperationMetaV2[] operations;
    private LedgerEntryChanges txChangesAfter;
    private SorobanTransactionMetaV2 sorobanMeta;
    private TransactionEvent[] events;
    private DiagnosticEvent[] diagnosticEvents;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.txChangesBefore.encode(stream);
        int operationsSize = this.getOperations().length;
        stream.writeInt(operationsSize);
        for (int i = 0; i < operationsSize; ++i) {
            this.operations[i].encode(stream);
        }
        this.txChangesAfter.encode(stream);
        if (this.sorobanMeta != null) {
            stream.writeInt(1);
            this.sorobanMeta.encode(stream);
        } else {
            stream.writeInt(0);
        }
        int eventsSize = this.getEvents().length;
        stream.writeInt(eventsSize);
        for (int i = 0; i < eventsSize; ++i) {
            this.events[i].encode(stream);
        }
        int diagnosticEventsSize = this.getDiagnosticEvents().length;
        stream.writeInt(diagnosticEventsSize);
        for (int i = 0; i < diagnosticEventsSize; ++i) {
            this.diagnosticEvents[i].encode(stream);
        }
    }

    public static TransactionMetaV4 decode(XdrDataInputStream stream) throws IOException {
        TransactionMetaV4 decodedTransactionMetaV4 = new TransactionMetaV4();
        decodedTransactionMetaV4.ext = ExtensionPoint.decode(stream);
        decodedTransactionMetaV4.txChangesBefore = LedgerEntryChanges.decode(stream);
        int operationsSize = stream.readInt();
        decodedTransactionMetaV4.operations = new OperationMetaV2[operationsSize];
        for (int i = 0; i < operationsSize; ++i) {
            decodedTransactionMetaV4.operations[i] = OperationMetaV2.decode(stream);
        }
        decodedTransactionMetaV4.txChangesAfter = LedgerEntryChanges.decode(stream);
        int sorobanMetaPresent = stream.readInt();
        if (sorobanMetaPresent != 0) {
            decodedTransactionMetaV4.sorobanMeta = SorobanTransactionMetaV2.decode(stream);
        }
        int eventsSize = stream.readInt();
        decodedTransactionMetaV4.events = new TransactionEvent[eventsSize];
        for (int i = 0; i < eventsSize; ++i) {
            decodedTransactionMetaV4.events[i] = TransactionEvent.decode(stream);
        }
        int diagnosticEventsSize = stream.readInt();
        decodedTransactionMetaV4.diagnosticEvents = new DiagnosticEvent[diagnosticEventsSize];
        for (int i = 0; i < diagnosticEventsSize; ++i) {
            decodedTransactionMetaV4.diagnosticEvents[i] = DiagnosticEvent.decode(stream);
        }
        return decodedTransactionMetaV4;
    }

    public static TransactionMetaV4 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionMetaV4.fromXdrByteArray(bytes);
    }

    public static TransactionMetaV4 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionMetaV4.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionMetaV4Builder builder() {
        return new TransactionMetaV4Builder();
    }

    @Generated
    public TransactionMetaV4Builder toBuilder() {
        return new TransactionMetaV4Builder().ext(this.ext).txChangesBefore(this.txChangesBefore).operations(this.operations).txChangesAfter(this.txChangesAfter).sorobanMeta(this.sorobanMeta).events(this.events).diagnosticEvents(this.diagnosticEvents);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public LedgerEntryChanges getTxChangesBefore() {
        return this.txChangesBefore;
    }

    @Generated
    public OperationMetaV2[] getOperations() {
        return this.operations;
    }

    @Generated
    public LedgerEntryChanges getTxChangesAfter() {
        return this.txChangesAfter;
    }

    @Generated
    public SorobanTransactionMetaV2 getSorobanMeta() {
        return this.sorobanMeta;
    }

    @Generated
    public TransactionEvent[] getEvents() {
        return this.events;
    }

    @Generated
    public DiagnosticEvent[] getDiagnosticEvents() {
        return this.diagnosticEvents;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setTxChangesBefore(LedgerEntryChanges txChangesBefore) {
        this.txChangesBefore = txChangesBefore;
    }

    @Generated
    public void setOperations(OperationMetaV2[] operations) {
        this.operations = operations;
    }

    @Generated
    public void setTxChangesAfter(LedgerEntryChanges txChangesAfter) {
        this.txChangesAfter = txChangesAfter;
    }

    @Generated
    public void setSorobanMeta(SorobanTransactionMetaV2 sorobanMeta) {
        this.sorobanMeta = sorobanMeta;
    }

    @Generated
    public void setEvents(TransactionEvent[] events) {
        this.events = events;
    }

    @Generated
    public void setDiagnosticEvents(DiagnosticEvent[] diagnosticEvents) {
        this.diagnosticEvents = diagnosticEvents;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionMetaV4)) {
            return false;
        }
        TransactionMetaV4 other = (TransactionMetaV4)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        LedgerEntryChanges this$txChangesBefore = this.getTxChangesBefore();
        LedgerEntryChanges other$txChangesBefore = other.getTxChangesBefore();
        if (this$txChangesBefore == null ? other$txChangesBefore != null : !((Object)this$txChangesBefore).equals(other$txChangesBefore)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperations(), other.getOperations())) {
            return false;
        }
        LedgerEntryChanges this$txChangesAfter = this.getTxChangesAfter();
        LedgerEntryChanges other$txChangesAfter = other.getTxChangesAfter();
        if (this$txChangesAfter == null ? other$txChangesAfter != null : !((Object)this$txChangesAfter).equals(other$txChangesAfter)) {
            return false;
        }
        SorobanTransactionMetaV2 this$sorobanMeta = this.getSorobanMeta();
        SorobanTransactionMetaV2 other$sorobanMeta = other.getSorobanMeta();
        if (this$sorobanMeta == null ? other$sorobanMeta != null : !((Object)this$sorobanMeta).equals(other$sorobanMeta)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEvents(), other.getEvents())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticEvents(), other.getDiagnosticEvents());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionMetaV4;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        LedgerEntryChanges $txChangesBefore = this.getTxChangesBefore();
        result = result * 59 + ($txChangesBefore == null ? 43 : ((Object)$txChangesBefore).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperations());
        LedgerEntryChanges $txChangesAfter = this.getTxChangesAfter();
        result = result * 59 + ($txChangesAfter == null ? 43 : ((Object)$txChangesAfter).hashCode());
        SorobanTransactionMetaV2 $sorobanMeta = this.getSorobanMeta();
        result = result * 59 + ($sorobanMeta == null ? 43 : ((Object)$sorobanMeta).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEvents());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticEvents());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionMetaV4(ext=" + this.getExt() + ", txChangesBefore=" + this.getTxChangesBefore() + ", operations=" + Arrays.deepToString(this.getOperations()) + ", txChangesAfter=" + this.getTxChangesAfter() + ", sorobanMeta=" + this.getSorobanMeta() + ", events=" + Arrays.deepToString(this.getEvents()) + ", diagnosticEvents=" + Arrays.deepToString(this.getDiagnosticEvents()) + ")";
    }

    @Generated
    public TransactionMetaV4() {
    }

    @Generated
    public TransactionMetaV4(ExtensionPoint ext, LedgerEntryChanges txChangesBefore, OperationMetaV2[] operations, LedgerEntryChanges txChangesAfter, SorobanTransactionMetaV2 sorobanMeta, TransactionEvent[] events, DiagnosticEvent[] diagnosticEvents) {
        this.ext = ext;
        this.txChangesBefore = txChangesBefore;
        this.operations = operations;
        this.txChangesAfter = txChangesAfter;
        this.sorobanMeta = sorobanMeta;
        this.events = events;
        this.diagnosticEvents = diagnosticEvents;
    }

    @Generated
    public static class TransactionMetaV4Builder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private LedgerEntryChanges txChangesBefore;
        @Generated
        private OperationMetaV2[] operations;
        @Generated
        private LedgerEntryChanges txChangesAfter;
        @Generated
        private SorobanTransactionMetaV2 sorobanMeta;
        @Generated
        private TransactionEvent[] events;
        @Generated
        private DiagnosticEvent[] diagnosticEvents;

        @Generated
        TransactionMetaV4Builder() {
        }

        @Generated
        public TransactionMetaV4Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public TransactionMetaV4Builder txChangesBefore(LedgerEntryChanges txChangesBefore) {
            this.txChangesBefore = txChangesBefore;
            return this;
        }

        @Generated
        public TransactionMetaV4Builder operations(OperationMetaV2[] operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public TransactionMetaV4Builder txChangesAfter(LedgerEntryChanges txChangesAfter) {
            this.txChangesAfter = txChangesAfter;
            return this;
        }

        @Generated
        public TransactionMetaV4Builder sorobanMeta(SorobanTransactionMetaV2 sorobanMeta) {
            this.sorobanMeta = sorobanMeta;
            return this;
        }

        @Generated
        public TransactionMetaV4Builder events(TransactionEvent[] events) {
            this.events = events;
            return this;
        }

        @Generated
        public TransactionMetaV4Builder diagnosticEvents(DiagnosticEvent[] diagnosticEvents) {
            this.diagnosticEvents = diagnosticEvents;
            return this;
        }

        @Generated
        public TransactionMetaV4 build() {
            return new TransactionMetaV4(this.ext, this.txChangesBefore, this.operations, this.txChangesAfter, this.sorobanMeta, this.events, this.diagnosticEvents);
        }

        @Generated
        public String toString() {
            return "TransactionMetaV4.TransactionMetaV4Builder(ext=" + this.ext + ", txChangesBefore=" + this.txChangesBefore + ", operations=" + Arrays.deepToString(this.operations) + ", txChangesAfter=" + this.txChangesAfter + ", sorobanMeta=" + this.sorobanMeta + ", events=" + Arrays.deepToString(this.events) + ", diagnosticEvents=" + Arrays.deepToString(this.diagnosticEvents) + ")";
        }
    }
}

