/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Memo;
import org.stellar.sdk.xdr.MemoType;
import org.stellar.sdk.xdr.XdrString;

public class MemoText
extends Memo {
    @NonNull
    private final XdrString text;

    public MemoText(@NonNull String text) {
        this(new XdrString(text));
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
    }

    public MemoText(byte @NonNull [] text) {
        this(new XdrString(text));
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
    }

    public MemoText(@NonNull XdrString text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (text.getBytes().length > 28) {
            throw new IllegalArgumentException("text cannot be more than 28-bytes long.");
        }
        this.text = text;
    }

    public String getText() {
        return this.text.toString();
    }

    public byte[] getBytes() {
        return this.text.getBytes();
    }

    @Override
    org.stellar.sdk.xdr.Memo toXdr() {
        org.stellar.sdk.xdr.Memo memo = new org.stellar.sdk.xdr.Memo();
        memo.setDiscriminant(MemoType.MEMO_TEXT);
        memo.setText(this.text);
        return memo;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoText)) {
            return false;
        }
        MemoText other = (MemoText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoText;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }
}

