/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.SignerKeyType;
import org.stellar.sdk.xdr.Uint256;

public final class SignerKey {
    public static final int SIGNED_PAYLOAD_MAX_PAYLOAD_LENGTH = 64;
    private final byte[] key;
    private final SignerKeyType type;

    public String getEncodedSignerKey() {
        switch (this.type) {
            case SIGNER_KEY_TYPE_ED25519: {
                return StrKey.encodeEd25519PublicKey(this.key);
            }
            case SIGNER_KEY_TYPE_PRE_AUTH_TX: {
                return StrKey.encodePreAuthTx(this.key);
            }
            case SIGNER_KEY_TYPE_HASH_X: {
                return StrKey.encodeSha256Hash(this.key);
            }
            case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD: {
                return StrKey.encodeSignedPayload(this.key);
            }
        }
        throw new IllegalArgumentException("Unknown SignerKeyType: " + this.type);
    }

    public static SignerKey fromEncodedSignerKey(String encodedSignerKey) {
        if (StrKey.isValidEd25519PublicKey(encodedSignerKey)) {
            return SignerKey.fromEd25519PublicKey(encodedSignerKey);
        }
        if (StrKey.isValidPreAuthTx(encodedSignerKey)) {
            return SignerKey.fromPreAuthTx(encodedSignerKey);
        }
        if (StrKey.isValidSha256Hash(encodedSignerKey)) {
            return SignerKey.fromSha256Hash(encodedSignerKey);
        }
        if (StrKey.isValidSignedPayload(encodedSignerKey)) {
            return SignerKey.fromEd25519SignedPayload(encodedSignerKey);
        }
        throw new IllegalArgumentException("Invalid encoded signer key: " + encodedSignerKey);
    }

    public static SignerKey fromEd25519PublicKey(byte[] key) {
        return new SignerKey(key, SignerKeyType.SIGNER_KEY_TYPE_ED25519);
    }

    public static SignerKey fromEd25519PublicKey(String key) {
        byte[] rawKey = StrKey.decodeEd25519PublicKey(key);
        return SignerKey.fromEd25519PublicKey(rawKey);
    }

    public static SignerKey fromPreAuthTx(byte[] key) {
        return new SignerKey(key, SignerKeyType.SIGNER_KEY_TYPE_PRE_AUTH_TX);
    }

    public static SignerKey fromPreAuthTx(String key) {
        byte[] rawKey = StrKey.decodePreAuthTx(key);
        return SignerKey.fromPreAuthTx(rawKey);
    }

    public static SignerKey fromPreAuthTx(Transaction key) {
        return SignerKey.fromPreAuthTx(key.hash());
    }

    public static SignerKey fromSha256Hash(byte[] key) {
        return new SignerKey(key, SignerKeyType.SIGNER_KEY_TYPE_HASH_X);
    }

    public static SignerKey fromSha256Hash(String key) {
        byte[] rawKey = StrKey.decodeSha256Hash(key);
        return SignerKey.fromSha256Hash(rawKey);
    }

    public static SignerKey fromEd25519SignedPayload(byte[] key) {
        return new SignerKey(key, SignerKeyType.SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD);
    }

    public static SignerKey fromEd25519SignedPayload(String ed25519PublicKey, byte[] payload) {
        byte[] publicKeyBytes = StrKey.decodeEd25519PublicKey(ed25519PublicKey);
        return SignerKey.fromEd25519SignedPayload(new Ed25519SignedPayload(publicKeyBytes, payload));
    }

    public static SignerKey fromEd25519SignedPayload(Ed25519SignedPayload ed25519SignedPayload) {
        int payloadLength = ed25519SignedPayload.payload.length;
        int paddingSize = (4 - payloadLength % 4) % 4;
        byte[] paddedPayload = new byte[payloadLength + paddingSize];
        System.arraycopy(ed25519SignedPayload.payload, 0, paddedPayload, 0, payloadLength);
        byte[] payloadLengthBytes = ByteBuffer.allocate(4).putInt(payloadLength).array();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(ed25519SignedPayload.ed25519PublicKey);
            outputStream.write(payloadLengthBytes);
            outputStream.write(paddedPayload);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        return new SignerKey(outputStream.toByteArray(), SignerKeyType.SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD);
    }

    public static SignerKey fromEd25519SignedPayload(String key) {
        byte[] rawKey = StrKey.decodeSignedPayload(key);
        return SignerKey.fromEd25519SignedPayload(rawKey);
    }

    public Ed25519SignedPayload toEd25519SignedPayload() {
        if (this.type != SignerKeyType.SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD) {
            throw new IllegalArgumentException("SignerKey type must be SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD");
        }
        byte[] lengthBytes = Arrays.copyOfRange(this.key, 32, 36);
        int payloadLength = ByteBuffer.wrap(lengthBytes).getInt();
        byte[] publicKeyBytes = Arrays.copyOfRange(this.key, 0, 32);
        byte[] payload = Arrays.copyOfRange(this.key, 36, 36 + payloadLength);
        return new Ed25519SignedPayload(publicKeyBytes, payload);
    }

    public org.stellar.sdk.xdr.SignerKey toXdr() {
        SignerKey.SignerKeyBuilder builder = org.stellar.sdk.xdr.SignerKey.builder().discriminant(this.type);
        switch (this.type) {
            case SIGNER_KEY_TYPE_ED25519: {
                return builder.ed25519(new Uint256(this.key)).build();
            }
            case SIGNER_KEY_TYPE_PRE_AUTH_TX: {
                return builder.preAuthTx(new Uint256(this.key)).build();
            }
            case SIGNER_KEY_TYPE_HASH_X: {
                return builder.hashX(new Uint256(this.key)).build();
            }
            case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD: {
                Ed25519SignedPayload ed25519SignedPayload = this.toEd25519SignedPayload();
                return builder.ed25519SignedPayload(new SignerKey.SignerKeyEd25519SignedPayload(new Uint256(ed25519SignedPayload.ed25519PublicKey), ed25519SignedPayload.payload)).build();
            }
        }
        throw new IllegalArgumentException("Unknown SignerKeyType: " + this.type);
    }

    public static SignerKey fromXdr(org.stellar.sdk.xdr.SignerKey signerKey) {
        switch (signerKey.getDiscriminant()) {
            case SIGNER_KEY_TYPE_ED25519: {
                return SignerKey.fromEd25519PublicKey(signerKey.getEd25519().getUint256());
            }
            case SIGNER_KEY_TYPE_PRE_AUTH_TX: {
                return SignerKey.fromPreAuthTx(signerKey.getPreAuthTx().getUint256());
            }
            case SIGNER_KEY_TYPE_HASH_X: {
                return SignerKey.fromSha256Hash(signerKey.getHashX().getUint256());
            }
            case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD: {
                SignerKey.SignerKeyEd25519SignedPayload ed25519SignedPayload = signerKey.getEd25519SignedPayload();
                return SignerKey.fromEd25519SignedPayload(new Ed25519SignedPayload(ed25519SignedPayload.getEd25519().getUint256(), ed25519SignedPayload.getPayload()));
            }
        }
        throw new IllegalArgumentException("Unknown SignerKeyType: " + signerKey.getDiscriminant());
    }

    @Generated
    public SignerKey(byte[] key, SignerKeyType type) {
        this.key = key;
        this.type = type;
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @Generated
    public SignerKeyType getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignerKey)) {
            return false;
        }
        SignerKey other = (SignerKey)o;
        if (!Arrays.equals(this.getKey(), other.getKey())) {
            return false;
        }
        SignerKeyType this$type = this.getType();
        SignerKeyType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getKey());
        SignerKeyType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignerKey(key=" + Arrays.toString(this.getKey()) + ", type=" + this.getType() + ")";
    }

    public static final class Ed25519SignedPayload {
        private final byte[] ed25519PublicKey;
        private final byte[] payload;

        public Ed25519SignedPayload(byte[] ed25519PublicKey, byte[] payload) {
            if (payload.length > 64) {
                throw new IllegalArgumentException("Invalid payload length, must be less than 64");
            }
            this.ed25519PublicKey = ed25519PublicKey;
            this.payload = payload;
        }

        public String getEncodedEd25519PublicKey() {
            return StrKey.encodeEd25519PublicKey(this.ed25519PublicKey);
        }

        @Generated
        public byte[] getEd25519PublicKey() {
            return this.ed25519PublicKey;
        }

        @Generated
        public byte[] getPayload() {
            return this.payload;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ed25519SignedPayload)) {
                return false;
            }
            Ed25519SignedPayload other = (Ed25519SignedPayload)o;
            if (!Arrays.equals(this.getEd25519PublicKey(), other.getEd25519PublicKey())) {
                return false;
            }
            return Arrays.equals(this.getPayload(), other.getPayload());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getEd25519PublicKey());
            result = result * 59 + Arrays.hashCode(this.getPayload());
            return result;
        }

        @Generated
        public String toString() {
            return "SignerKey.Ed25519SignedPayload(ed25519PublicKey=" + Arrays.toString(this.getEd25519PublicKey()) + ", payload=" + Arrays.toString(this.getPayload()) + ")";
        }
    }
}

