/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.ClaimClaimableBalanceOp;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ClaimClaimableBalanceOperation
extends Operation {
    @NonNull
    private final String balanceId;

    public static ClaimClaimableBalanceOperation fromXdr(ClaimClaimableBalanceOp op) {
        try {
            String balanceId = Util.bytesToHex(op.getBalanceID().toXdrByteArray()).toLowerCase();
            return new ClaimClaimableBalanceOperation(balanceId);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid balanceId in the operation", e);
        }
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ClaimableBalanceID balanceId;
        byte[] balanceIdBytes = Util.hexToBytes(this.balanceId);
        try {
            balanceId = ClaimableBalanceID.fromXdrByteArray(balanceIdBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid balanceId: " + this.balanceId, e);
        }
        ClaimClaimableBalanceOp op = new ClaimClaimableBalanceOp();
        op.setBalanceID(balanceId);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAIM_CLAIMABLE_BALANCE);
        body.setClaimClaimableBalanceOp(op);
        return body;
    }

    @Generated
    protected ClaimClaimableBalanceOperation(ClaimClaimableBalanceOperationBuilder<?, ?> b) {
        super(b);
        this.balanceId = ((ClaimClaimableBalanceOperationBuilder)b).balanceId;
        if (this.balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
    }

    @Generated
    public static ClaimClaimableBalanceOperationBuilder<?, ?> builder() {
        return new ClaimClaimableBalanceOperationBuilderImpl();
    }

    @Generated
    public ClaimClaimableBalanceOperationBuilder<?, ?> toBuilder() {
        return new ClaimClaimableBalanceOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getBalanceId() {
        return this.balanceId;
    }

    @Generated
    public String toString() {
        return "ClaimClaimableBalanceOperation(super=" + super.toString() + ", balanceId=" + this.getBalanceId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimClaimableBalanceOperation)) {
            return false;
        }
        ClaimClaimableBalanceOperation other = (ClaimClaimableBalanceOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$balanceId = this.getBalanceId();
        String other$balanceId = other.getBalanceId();
        return !(this$balanceId == null ? other$balanceId != null : !this$balanceId.equals(other$balanceId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimClaimableBalanceOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $balanceId = this.getBalanceId();
        result = result * 59 + ($balanceId == null ? 43 : $balanceId.hashCode());
        return result;
    }

    @Generated
    private ClaimClaimableBalanceOperation(@NonNull String balanceId) {
        if (balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
        this.balanceId = balanceId;
    }

    @Generated
    private static final class ClaimClaimableBalanceOperationBuilderImpl
    extends ClaimClaimableBalanceOperationBuilder<ClaimClaimableBalanceOperation, ClaimClaimableBalanceOperationBuilderImpl> {
        @Generated
        private ClaimClaimableBalanceOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected ClaimClaimableBalanceOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ClaimClaimableBalanceOperation build() {
            return new ClaimClaimableBalanceOperation(this);
        }
    }

    public static abstract class ClaimClaimableBalanceOperationBuilder<C extends ClaimClaimableBalanceOperation, B extends ClaimClaimableBalanceOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String balanceId;

        public B balanceId(@NonNull String balanceId) {
            if (balanceId == null) {
                throw new NullPointerException("balanceId is marked non-null but is null");
            }
            if (balanceId.length() != 72) {
                throw new IllegalArgumentException("invalid balanceId: " + balanceId);
            }
            this.balanceId = balanceId.toLowerCase();
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ClaimClaimableBalanceOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ClaimClaimableBalanceOperation instance, ClaimClaimableBalanceOperationBuilder<?, ?> b) {
            b.balanceId(instance.balanceId);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ClaimClaimableBalanceOperation.ClaimClaimableBalanceOperationBuilder(super=" + super.toString() + ", balanceId=" + this.balanceId + ")";
        }
    }
}

