/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.Closeable;
import java.net.SocketException;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.sse.RealEventSource;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Util;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.gson.GsonSingleton;

public class SSEStream<T extends org.stellar.sdk.responses.Response>
implements Closeable {
    static final long DEFAULT_RECONNECT_TIMEOUT = 15000L;
    private final OkHttpClient okHttpClient;
    private final RequestBuilder requestBuilder;
    private final Class<T> responseClass;
    private final EventListener<T> listener;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final AtomicBoolean isClosed = new AtomicBoolean(true);
    private final AtomicLong latestEventTime = new AtomicLong(0L);
    private final AtomicReference<String> lastEventId = new AtomicReference<Object>(null);
    private final ScheduledExecutorService executorService;
    private final AtomicReference<EventSource> eventSource = new AtomicReference<Object>(null);
    private final long reconnectTimeout;
    private final AtomicLong currentListenerId = new AtomicLong(0L);

    private SSEStream(OkHttpClient okHttpClient, RequestBuilder requestBuilder, Class<T> responseClass, EventListener<T> listener, long reconnectTimeout) {
        this.okHttpClient = okHttpClient.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.requestBuilder = requestBuilder;
        this.responseClass = responseClass;
        this.listener = listener;
        this.reconnectTimeout = reconnectTimeout;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        requestBuilder.buildUri();
    }

    private void start() {
        if (this.isStopped.get()) {
            throw new IllegalStateException("Already stopped");
        }
        this.executorService.scheduleWithFixedDelay(() -> {
            if (System.currentTimeMillis() - this.latestEventTime.get() > this.reconnectTimeout) {
                this.latestEventTime.set(System.currentTimeMillis());
                this.isClosed.compareAndSet(false, true);
            }
            if (this.isClosed.get()) {
                this.isClosed.compareAndSet(true, false);
                if (!this.isStopped.get()) {
                    this.restart();
                }
            }
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    public String lastPagingToken() {
        return this.lastEventId.get();
    }

    private void restart() {
        EventSource currentEventSource = this.eventSource.get();
        if (currentEventSource != null) {
            currentEventSource.cancel();
        }
        long newListenerId = this.currentListenerId.incrementAndGet();
        this.eventSource.set(SSEStream.doStreamRequest(this, this.okHttpClient, this.requestBuilder, this.responseClass, this.listener, this.requestBuilder.uriBuilder.build().toString(), source -> this.isClosed.compareAndSet(false, true), newListenerId));
    }

    @Override
    public void close() {
        if (this.isStopped.compareAndSet(false, true)) {
            EventSource currentEventSource = this.eventSource.get();
            if (currentEventSource != null) {
                currentEventSource.cancel();
            }
            this.executorService.shutdownNow();
        }
    }

    static <T extends org.stellar.sdk.responses.Response> SSEStream<T> create(OkHttpClient okHttpClient, RequestBuilder requestBuilder, Class<T> responseClass, EventListener<T> listener, long reconnectTimeout) {
        SSEStream<T> stream = new SSEStream<T>(okHttpClient, requestBuilder, responseClass, listener, reconnectTimeout);
        super.start();
        return stream;
    }

    private static String addIdentificationQueryParameter(String url) {
        HttpUrl parsedUrl = HttpUrl.parse((String)url);
        if (parsedUrl == null) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        return parsedUrl.newBuilder().addQueryParameter("X-Client-Name", "java-stellar-sdk").addQueryParameter("X-Client-Version", Util.getSdkVersion()).build().toString();
    }

    private static <T extends org.stellar.sdk.responses.Response> EventSource doStreamRequest(SSEStream<T> stream, OkHttpClient okHttpClient, RequestBuilder requestBuilder, Class<T> responseClass, EventListener<T> listener, String url, CloseListener closeListener, long listenerId) {
        Request.Builder builder = new Request.Builder().url(SSEStream.addIdentificationQueryParameter(url)).header("Accept", "text/event-stream");
        String lastEventId = stream.lastEventId.get();
        if (lastEventId != null) {
            builder.header("Last-Event-ID", lastEventId);
        }
        Request request = builder.build();
        RealEventSource eventSource = new RealEventSource(request, new StellarEventSourceListener<T>(stream, closeListener, responseClass, requestBuilder, listener, listenerId));
        eventSource.connect(okHttpClient);
        return eventSource;
    }

    private static class StellarEventSourceListener<T extends org.stellar.sdk.responses.Response>
    extends EventSourceListener {
        private final SSEStream<T> stream;
        private final CloseListener closeListener;
        private final Class<T> responseClass;
        private final RequestBuilder requestBuilder;
        private final EventListener<T> listener;
        private final long listenerId;

        StellarEventSourceListener(SSEStream<T> stream, CloseListener closeListener, Class<T> responseClass, RequestBuilder requestBuilder, EventListener<T> listener, long listenerId) {
            this.stream = stream;
            this.closeListener = closeListener;
            this.responseClass = responseClass;
            this.requestBuilder = requestBuilder;
            this.listener = listener;
            this.listenerId = listenerId;
        }

        public void onClosed(@NotNull EventSource eventSource) {
            if (((SSEStream)this.stream).isStopped.get() || this.listenerId != ((SSEStream)this.stream).currentListenerId.get()) {
                return;
            }
            if (this.closeListener != null) {
                this.closeListener.closed(eventSource);
            }
        }

        public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
        }

        public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
            if (((SSEStream)this.stream).isStopped.get() || this.listenerId != ((SSEStream)this.stream).currentListenerId.get()) {
                return;
            }
            Optional<Integer> code = Optional.empty();
            if (response != null) {
                code = Optional.of(response.code());
            }
            if (t != null) {
                if (t instanceof SocketException) {
                    if (this.closeListener != null) {
                        this.closeListener.closed(eventSource);
                    }
                } else {
                    this.listener.onFailure(Optional.of(t), code);
                }
            } else {
                Optional<Throwable> absent = Optional.empty();
                this.listener.onFailure(absent, code);
            }
        }

        public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
            if (((SSEStream)this.stream).isStopped.get() || this.listenerId != ((SSEStream)this.stream).currentListenerId.get()) {
                return;
            }
            ((SSEStream)this.stream).latestEventTime.set(System.currentTimeMillis());
            if (data.equals("\"hello\"") || data.equals("\"byebye\"")) {
                return;
            }
            org.stellar.sdk.responses.Response event = (org.stellar.sdk.responses.Response)GsonSingleton.getInstance().fromJson(data, this.responseClass);
            if (event instanceof Pageable) {
                String pagingToken = ((Pageable)((Object)event)).getPagingToken();
                this.requestBuilder.cursor(pagingToken);
            }
            ((SSEStream)this.stream).lastEventId.set(id);
            this.listener.onEvent(event);
        }
    }

    private static interface CloseListener {
        public void closed(EventSource var1);
    }
}

