/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountEntryExtensionV1;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.Signer;
import org.stellar.sdk.xdr.String32;
import org.stellar.sdk.xdr.Thresholds;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountEntry
implements XdrElement {
    private AccountID accountID;
    private Int64 balance;
    private SequenceNumber seqNum;
    private Uint32 numSubEntries;
    private AccountID inflationDest;
    private Uint32 flags;
    private String32 homeDomain;
    private Thresholds thresholds;
    private Signer[] signers;
    private AccountEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.accountID.encode(stream);
        this.balance.encode(stream);
        this.seqNum.encode(stream);
        this.numSubEntries.encode(stream);
        if (this.inflationDest != null) {
            stream.writeInt(1);
            this.inflationDest.encode(stream);
        } else {
            stream.writeInt(0);
        }
        this.flags.encode(stream);
        this.homeDomain.encode(stream);
        this.thresholds.encode(stream);
        int signersSize = this.getSigners().length;
        stream.writeInt(signersSize);
        for (int i = 0; i < signersSize; ++i) {
            this.signers[i].encode(stream);
        }
        this.ext.encode(stream);
    }

    public static AccountEntry decode(XdrDataInputStream stream) throws IOException {
        AccountEntry decodedAccountEntry = new AccountEntry();
        decodedAccountEntry.accountID = AccountID.decode(stream);
        decodedAccountEntry.balance = Int64.decode(stream);
        decodedAccountEntry.seqNum = SequenceNumber.decode(stream);
        decodedAccountEntry.numSubEntries = Uint32.decode(stream);
        int inflationDestPresent = stream.readInt();
        if (inflationDestPresent != 0) {
            decodedAccountEntry.inflationDest = AccountID.decode(stream);
        }
        decodedAccountEntry.flags = Uint32.decode(stream);
        decodedAccountEntry.homeDomain = String32.decode(stream);
        decodedAccountEntry.thresholds = Thresholds.decode(stream);
        int signersSize = stream.readInt();
        decodedAccountEntry.signers = new Signer[signersSize];
        for (int i = 0; i < signersSize; ++i) {
            decodedAccountEntry.signers[i] = Signer.decode(stream);
        }
        decodedAccountEntry.ext = AccountEntryExt.decode(stream);
        return decodedAccountEntry;
    }

    public static AccountEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountEntry.fromXdrByteArray(bytes);
    }

    public static AccountEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static AccountEntryBuilder builder() {
        return new AccountEntryBuilder();
    }

    @Generated
    public AccountEntryBuilder toBuilder() {
        return new AccountEntryBuilder().accountID(this.accountID).balance(this.balance).seqNum(this.seqNum).numSubEntries(this.numSubEntries).inflationDest(this.inflationDest).flags(this.flags).homeDomain(this.homeDomain).thresholds(this.thresholds).signers(this.signers).ext(this.ext);
    }

    @Generated
    public AccountID getAccountID() {
        return this.accountID;
    }

    @Generated
    public Int64 getBalance() {
        return this.balance;
    }

    @Generated
    public SequenceNumber getSeqNum() {
        return this.seqNum;
    }

    @Generated
    public Uint32 getNumSubEntries() {
        return this.numSubEntries;
    }

    @Generated
    public AccountID getInflationDest() {
        return this.inflationDest;
    }

    @Generated
    public Uint32 getFlags() {
        return this.flags;
    }

    @Generated
    public String32 getHomeDomain() {
        return this.homeDomain;
    }

    @Generated
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    @Generated
    public Signer[] getSigners() {
        return this.signers;
    }

    @Generated
    public AccountEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setAccountID(AccountID accountID) {
        this.accountID = accountID;
    }

    @Generated
    public void setBalance(Int64 balance) {
        this.balance = balance;
    }

    @Generated
    public void setSeqNum(SequenceNumber seqNum) {
        this.seqNum = seqNum;
    }

    @Generated
    public void setNumSubEntries(Uint32 numSubEntries) {
        this.numSubEntries = numSubEntries;
    }

    @Generated
    public void setInflationDest(AccountID inflationDest) {
        this.inflationDest = inflationDest;
    }

    @Generated
    public void setFlags(Uint32 flags) {
        this.flags = flags;
    }

    @Generated
    public void setHomeDomain(String32 homeDomain) {
        this.homeDomain = homeDomain;
    }

    @Generated
    public void setThresholds(Thresholds thresholds) {
        this.thresholds = thresholds;
    }

    @Generated
    public void setSigners(Signer[] signers) {
        this.signers = signers;
    }

    @Generated
    public void setExt(AccountEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountEntry)) {
            return false;
        }
        AccountEntry other = (AccountEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$accountID = this.getAccountID();
        AccountID other$accountID = other.getAccountID();
        if (this$accountID == null ? other$accountID != null : !((Object)this$accountID).equals(other$accountID)) {
            return false;
        }
        Int64 this$balance = this.getBalance();
        Int64 other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        SequenceNumber this$seqNum = this.getSeqNum();
        SequenceNumber other$seqNum = other.getSeqNum();
        if (this$seqNum == null ? other$seqNum != null : !((Object)this$seqNum).equals(other$seqNum)) {
            return false;
        }
        Uint32 this$numSubEntries = this.getNumSubEntries();
        Uint32 other$numSubEntries = other.getNumSubEntries();
        if (this$numSubEntries == null ? other$numSubEntries != null : !((Object)this$numSubEntries).equals(other$numSubEntries)) {
            return false;
        }
        AccountID this$inflationDest = this.getInflationDest();
        AccountID other$inflationDest = other.getInflationDest();
        if (this$inflationDest == null ? other$inflationDest != null : !((Object)this$inflationDest).equals(other$inflationDest)) {
            return false;
        }
        Uint32 this$flags = this.getFlags();
        Uint32 other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        String32 this$homeDomain = this.getHomeDomain();
        String32 other$homeDomain = other.getHomeDomain();
        if (this$homeDomain == null ? other$homeDomain != null : !((Object)this$homeDomain).equals(other$homeDomain)) {
            return false;
        }
        Thresholds this$thresholds = this.getThresholds();
        Thresholds other$thresholds = other.getThresholds();
        if (this$thresholds == null ? other$thresholds != null : !((Object)this$thresholds).equals(other$thresholds)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSigners(), other.getSigners())) {
            return false;
        }
        AccountEntryExt this$ext = this.getExt();
        AccountEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $accountID = this.getAccountID();
        result = result * 59 + ($accountID == null ? 43 : ((Object)$accountID).hashCode());
        Int64 $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        SequenceNumber $seqNum = this.getSeqNum();
        result = result * 59 + ($seqNum == null ? 43 : ((Object)$seqNum).hashCode());
        Uint32 $numSubEntries = this.getNumSubEntries();
        result = result * 59 + ($numSubEntries == null ? 43 : ((Object)$numSubEntries).hashCode());
        AccountID $inflationDest = this.getInflationDest();
        result = result * 59 + ($inflationDest == null ? 43 : ((Object)$inflationDest).hashCode());
        Uint32 $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        String32 $homeDomain = this.getHomeDomain();
        result = result * 59 + ($homeDomain == null ? 43 : ((Object)$homeDomain).hashCode());
        Thresholds $thresholds = this.getThresholds();
        result = result * 59 + ($thresholds == null ? 43 : ((Object)$thresholds).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSigners());
        AccountEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountEntry(accountID=" + this.getAccountID() + ", balance=" + this.getBalance() + ", seqNum=" + this.getSeqNum() + ", numSubEntries=" + this.getNumSubEntries() + ", inflationDest=" + this.getInflationDest() + ", flags=" + this.getFlags() + ", homeDomain=" + this.getHomeDomain() + ", thresholds=" + this.getThresholds() + ", signers=" + Arrays.deepToString(this.getSigners()) + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public AccountEntry() {
    }

    @Generated
    public AccountEntry(AccountID accountID, Int64 balance, SequenceNumber seqNum, Uint32 numSubEntries, AccountID inflationDest, Uint32 flags, String32 homeDomain, Thresholds thresholds, Signer[] signers, AccountEntryExt ext) {
        this.accountID = accountID;
        this.balance = balance;
        this.seqNum = seqNum;
        this.numSubEntries = numSubEntries;
        this.inflationDest = inflationDest;
        this.flags = flags;
        this.homeDomain = homeDomain;
        this.thresholds = thresholds;
        this.signers = signers;
        this.ext = ext;
    }

    @Generated
    public static class AccountEntryBuilder {
        @Generated
        private AccountID accountID;
        @Generated
        private Int64 balance;
        @Generated
        private SequenceNumber seqNum;
        @Generated
        private Uint32 numSubEntries;
        @Generated
        private AccountID inflationDest;
        @Generated
        private Uint32 flags;
        @Generated
        private String32 homeDomain;
        @Generated
        private Thresholds thresholds;
        @Generated
        private Signer[] signers;
        @Generated
        private AccountEntryExt ext;

        @Generated
        AccountEntryBuilder() {
        }

        @Generated
        public AccountEntryBuilder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        @Generated
        public AccountEntryBuilder balance(Int64 balance) {
            this.balance = balance;
            return this;
        }

        @Generated
        public AccountEntryBuilder seqNum(SequenceNumber seqNum) {
            this.seqNum = seqNum;
            return this;
        }

        @Generated
        public AccountEntryBuilder numSubEntries(Uint32 numSubEntries) {
            this.numSubEntries = numSubEntries;
            return this;
        }

        @Generated
        public AccountEntryBuilder inflationDest(AccountID inflationDest) {
            this.inflationDest = inflationDest;
            return this;
        }

        @Generated
        public AccountEntryBuilder flags(Uint32 flags) {
            this.flags = flags;
            return this;
        }

        @Generated
        public AccountEntryBuilder homeDomain(String32 homeDomain) {
            this.homeDomain = homeDomain;
            return this;
        }

        @Generated
        public AccountEntryBuilder thresholds(Thresholds thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        @Generated
        public AccountEntryBuilder signers(Signer[] signers) {
            this.signers = signers;
            return this;
        }

        @Generated
        public AccountEntryBuilder ext(AccountEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public AccountEntry build() {
            return new AccountEntry(this.accountID, this.balance, this.seqNum, this.numSubEntries, this.inflationDest, this.flags, this.homeDomain, this.thresholds, this.signers, this.ext);
        }

        @Generated
        public String toString() {
            return "AccountEntry.AccountEntryBuilder(accountID=" + this.accountID + ", balance=" + this.balance + ", seqNum=" + this.seqNum + ", numSubEntries=" + this.numSubEntries + ", inflationDest=" + this.inflationDest + ", flags=" + this.flags + ", homeDomain=" + this.homeDomain + ", thresholds=" + this.thresholds + ", signers=" + Arrays.deepToString(this.signers) + ", ext=" + this.ext + ")";
        }
    }

    public static class AccountEntryExt
    implements XdrElement {
        private Integer discriminant;
        private AccountEntryExtensionV1 v1;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.v1.encode(stream);
                }
            }
        }

        public static AccountEntryExt decode(XdrDataInputStream stream) throws IOException {
            AccountEntryExt decodedAccountEntryExt = new AccountEntryExt();
            Integer discriminant = stream.readInt();
            decodedAccountEntryExt.setDiscriminant(discriminant);
            switch (decodedAccountEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedAccountEntryExt.v1 = AccountEntryExtensionV1.decode(stream);
                }
            }
            return decodedAccountEntryExt;
        }

        public static AccountEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return AccountEntryExt.fromXdrByteArray(bytes);
        }

        public static AccountEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return AccountEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static AccountEntryExtBuilder builder() {
            return new AccountEntryExtBuilder();
        }

        @Generated
        public AccountEntryExtBuilder toBuilder() {
            return new AccountEntryExtBuilder().discriminant(this.discriminant).v1(this.v1);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public AccountEntryExtensionV1 getV1() {
            return this.v1;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV1(AccountEntryExtensionV1 v1) {
            this.v1 = v1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountEntryExt)) {
                return false;
            }
            AccountEntryExt other = (AccountEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            AccountEntryExtensionV1 this$v1 = this.getV1();
            AccountEntryExtensionV1 other$v1 = other.getV1();
            return !(this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccountEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            AccountEntryExtensionV1 $v1 = this.getV1();
            result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountEntry.AccountEntryExt(discriminant=" + this.getDiscriminant() + ", v1=" + this.getV1() + ")";
        }

        @Generated
        public AccountEntryExt() {
        }

        @Generated
        public AccountEntryExt(Integer discriminant, AccountEntryExtensionV1 v1) {
            this.discriminant = discriminant;
            this.v1 = v1;
        }

        @Generated
        public static class AccountEntryExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private AccountEntryExtensionV1 v1;

            @Generated
            AccountEntryExtBuilder() {
            }

            @Generated
            public AccountEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public AccountEntryExtBuilder v1(AccountEntryExtensionV1 v1) {
                this.v1 = v1;
                return this;
            }

            @Generated
            public AccountEntryExt build() {
                return new AccountEntryExt(this.discriminant, this.v1);
            }

            @Generated
            public String toString() {
                return "AccountEntry.AccountEntryExt.AccountEntryExtBuilder(discriminant=" + this.discriminant + ", v1=" + this.v1 + ")";
            }
        }
    }
}

