/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ChangeTrustResultCode implements XdrElement
{
    CHANGE_TRUST_SUCCESS(0),
    CHANGE_TRUST_MALFORMED(-1),
    CHANGE_TRUST_NO_ISSUER(-2),
    CHANGE_TRUST_INVALID_LIMIT(-3),
    CHANGE_TRUST_LOW_RESERVE(-4),
    CHANGE_TRUST_SELF_NOT_ALLOWED(-5),
    CHANGE_TRUST_TRUST_LINE_MISSING(-6),
    CHANGE_TRUST_CANNOT_DELETE(-7),
    CHANGE_TRUST_NOT_AUTH_MAINTAIN_LIABILITIES(-8);

    private final int value;

    private ChangeTrustResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ChangeTrustResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CHANGE_TRUST_SUCCESS;
            }
            case -1: {
                return CHANGE_TRUST_MALFORMED;
            }
            case -2: {
                return CHANGE_TRUST_NO_ISSUER;
            }
            case -3: {
                return CHANGE_TRUST_INVALID_LIMIT;
            }
            case -4: {
                return CHANGE_TRUST_LOW_RESERVE;
            }
            case -5: {
                return CHANGE_TRUST_SELF_NOT_ALLOWED;
            }
            case -6: {
                return CHANGE_TRUST_TRUST_LINE_MISSING;
            }
            case -7: {
                return CHANGE_TRUST_CANNOT_DELETE;
            }
            case -8: {
                return CHANGE_TRUST_NOT_AUTH_MAINTAIN_LIABILITIES;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ChangeTrustResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ChangeTrustResultCode.fromXdrByteArray(bytes);
    }

    public static ChangeTrustResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ChangeTrustResultCode.decode(xdrDataInputStream);
    }
}

