/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimLiquidityAtom
implements XdrElement {
    private PoolID liquidityPoolID;
    private Asset assetSold;
    private Int64 amountSold;
    private Asset assetBought;
    private Int64 amountBought;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.liquidityPoolID.encode(stream);
        this.assetSold.encode(stream);
        this.amountSold.encode(stream);
        this.assetBought.encode(stream);
        this.amountBought.encode(stream);
    }

    public static ClaimLiquidityAtom decode(XdrDataInputStream stream) throws IOException {
        ClaimLiquidityAtom decodedClaimLiquidityAtom = new ClaimLiquidityAtom();
        decodedClaimLiquidityAtom.liquidityPoolID = PoolID.decode(stream);
        decodedClaimLiquidityAtom.assetSold = Asset.decode(stream);
        decodedClaimLiquidityAtom.amountSold = Int64.decode(stream);
        decodedClaimLiquidityAtom.assetBought = Asset.decode(stream);
        decodedClaimLiquidityAtom.amountBought = Int64.decode(stream);
        return decodedClaimLiquidityAtom;
    }

    public static ClaimLiquidityAtom fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimLiquidityAtom.fromXdrByteArray(bytes);
    }

    public static ClaimLiquidityAtom fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimLiquidityAtom.decode(xdrDataInputStream);
    }

    @Generated
    public static ClaimLiquidityAtomBuilder builder() {
        return new ClaimLiquidityAtomBuilder();
    }

    @Generated
    public ClaimLiquidityAtomBuilder toBuilder() {
        return new ClaimLiquidityAtomBuilder().liquidityPoolID(this.liquidityPoolID).assetSold(this.assetSold).amountSold(this.amountSold).assetBought(this.assetBought).amountBought(this.amountBought);
    }

    @Generated
    public PoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    @Generated
    public Asset getAssetSold() {
        return this.assetSold;
    }

    @Generated
    public Int64 getAmountSold() {
        return this.amountSold;
    }

    @Generated
    public Asset getAssetBought() {
        return this.assetBought;
    }

    @Generated
    public Int64 getAmountBought() {
        return this.amountBought;
    }

    @Generated
    public void setLiquidityPoolID(PoolID liquidityPoolID) {
        this.liquidityPoolID = liquidityPoolID;
    }

    @Generated
    public void setAssetSold(Asset assetSold) {
        this.assetSold = assetSold;
    }

    @Generated
    public void setAmountSold(Int64 amountSold) {
        this.amountSold = amountSold;
    }

    @Generated
    public void setAssetBought(Asset assetBought) {
        this.assetBought = assetBought;
    }

    @Generated
    public void setAmountBought(Int64 amountBought) {
        this.amountBought = amountBought;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimLiquidityAtom)) {
            return false;
        }
        ClaimLiquidityAtom other = (ClaimLiquidityAtom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PoolID this$liquidityPoolID = this.getLiquidityPoolID();
        PoolID other$liquidityPoolID = other.getLiquidityPoolID();
        if (this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID)) {
            return false;
        }
        Asset this$assetSold = this.getAssetSold();
        Asset other$assetSold = other.getAssetSold();
        if (this$assetSold == null ? other$assetSold != null : !((Object)this$assetSold).equals(other$assetSold)) {
            return false;
        }
        Int64 this$amountSold = this.getAmountSold();
        Int64 other$amountSold = other.getAmountSold();
        if (this$amountSold == null ? other$amountSold != null : !((Object)this$amountSold).equals(other$amountSold)) {
            return false;
        }
        Asset this$assetBought = this.getAssetBought();
        Asset other$assetBought = other.getAssetBought();
        if (this$assetBought == null ? other$assetBought != null : !((Object)this$assetBought).equals(other$assetBought)) {
            return false;
        }
        Int64 this$amountBought = this.getAmountBought();
        Int64 other$amountBought = other.getAmountBought();
        return !(this$amountBought == null ? other$amountBought != null : !((Object)this$amountBought).equals(other$amountBought));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimLiquidityAtom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PoolID $liquidityPoolID = this.getLiquidityPoolID();
        result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
        Asset $assetSold = this.getAssetSold();
        result = result * 59 + ($assetSold == null ? 43 : ((Object)$assetSold).hashCode());
        Int64 $amountSold = this.getAmountSold();
        result = result * 59 + ($amountSold == null ? 43 : ((Object)$amountSold).hashCode());
        Asset $assetBought = this.getAssetBought();
        result = result * 59 + ($assetBought == null ? 43 : ((Object)$assetBought).hashCode());
        Int64 $amountBought = this.getAmountBought();
        result = result * 59 + ($amountBought == null ? 43 : ((Object)$amountBought).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClaimLiquidityAtom(liquidityPoolID=" + this.getLiquidityPoolID() + ", assetSold=" + this.getAssetSold() + ", amountSold=" + this.getAmountSold() + ", assetBought=" + this.getAssetBought() + ", amountBought=" + this.getAmountBought() + ")";
    }

    @Generated
    public ClaimLiquidityAtom() {
    }

    @Generated
    public ClaimLiquidityAtom(PoolID liquidityPoolID, Asset assetSold, Int64 amountSold, Asset assetBought, Int64 amountBought) {
        this.liquidityPoolID = liquidityPoolID;
        this.assetSold = assetSold;
        this.amountSold = amountSold;
        this.assetBought = assetBought;
        this.amountBought = amountBought;
    }

    @Generated
    public static class ClaimLiquidityAtomBuilder {
        @Generated
        private PoolID liquidityPoolID;
        @Generated
        private Asset assetSold;
        @Generated
        private Int64 amountSold;
        @Generated
        private Asset assetBought;
        @Generated
        private Int64 amountBought;

        @Generated
        ClaimLiquidityAtomBuilder() {
        }

        @Generated
        public ClaimLiquidityAtomBuilder liquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
            return this;
        }

        @Generated
        public ClaimLiquidityAtomBuilder assetSold(Asset assetSold) {
            this.assetSold = assetSold;
            return this;
        }

        @Generated
        public ClaimLiquidityAtomBuilder amountSold(Int64 amountSold) {
            this.amountSold = amountSold;
            return this;
        }

        @Generated
        public ClaimLiquidityAtomBuilder assetBought(Asset assetBought) {
            this.assetBought = assetBought;
            return this;
        }

        @Generated
        public ClaimLiquidityAtomBuilder amountBought(Int64 amountBought) {
            this.amountBought = amountBought;
            return this;
        }

        @Generated
        public ClaimLiquidityAtom build() {
            return new ClaimLiquidityAtom(this.liquidityPoolID, this.assetSold, this.amountSold, this.assetBought, this.amountBought);
        }

        @Generated
        public String toString() {
            return "ClaimLiquidityAtom.ClaimLiquidityAtomBuilder(liquidityPoolID=" + this.liquidityPoolID + ", assetSold=" + this.assetSold + ", amountSold=" + this.amountSold + ", assetBought=" + this.assetBought + ", amountBought=" + this.amountBought + ")";
        }
    }
}

