/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimOfferAtom
implements XdrElement {
    private AccountID sellerID;
    private Int64 offerID;
    private Asset assetSold;
    private Int64 amountSold;
    private Asset assetBought;
    private Int64 amountBought;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.sellerID.encode(stream);
        this.offerID.encode(stream);
        this.assetSold.encode(stream);
        this.amountSold.encode(stream);
        this.assetBought.encode(stream);
        this.amountBought.encode(stream);
    }

    public static ClaimOfferAtom decode(XdrDataInputStream stream) throws IOException {
        ClaimOfferAtom decodedClaimOfferAtom = new ClaimOfferAtom();
        decodedClaimOfferAtom.sellerID = AccountID.decode(stream);
        decodedClaimOfferAtom.offerID = Int64.decode(stream);
        decodedClaimOfferAtom.assetSold = Asset.decode(stream);
        decodedClaimOfferAtom.amountSold = Int64.decode(stream);
        decodedClaimOfferAtom.assetBought = Asset.decode(stream);
        decodedClaimOfferAtom.amountBought = Int64.decode(stream);
        return decodedClaimOfferAtom;
    }

    public static ClaimOfferAtom fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimOfferAtom.fromXdrByteArray(bytes);
    }

    public static ClaimOfferAtom fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimOfferAtom.decode(xdrDataInputStream);
    }

    @Generated
    public static ClaimOfferAtomBuilder builder() {
        return new ClaimOfferAtomBuilder();
    }

    @Generated
    public ClaimOfferAtomBuilder toBuilder() {
        return new ClaimOfferAtomBuilder().sellerID(this.sellerID).offerID(this.offerID).assetSold(this.assetSold).amountSold(this.amountSold).assetBought(this.assetBought).amountBought(this.amountBought);
    }

    @Generated
    public AccountID getSellerID() {
        return this.sellerID;
    }

    @Generated
    public Int64 getOfferID() {
        return this.offerID;
    }

    @Generated
    public Asset getAssetSold() {
        return this.assetSold;
    }

    @Generated
    public Int64 getAmountSold() {
        return this.amountSold;
    }

    @Generated
    public Asset getAssetBought() {
        return this.assetBought;
    }

    @Generated
    public Int64 getAmountBought() {
        return this.amountBought;
    }

    @Generated
    public void setSellerID(AccountID sellerID) {
        this.sellerID = sellerID;
    }

    @Generated
    public void setOfferID(Int64 offerID) {
        this.offerID = offerID;
    }

    @Generated
    public void setAssetSold(Asset assetSold) {
        this.assetSold = assetSold;
    }

    @Generated
    public void setAmountSold(Int64 amountSold) {
        this.amountSold = amountSold;
    }

    @Generated
    public void setAssetBought(Asset assetBought) {
        this.assetBought = assetBought;
    }

    @Generated
    public void setAmountBought(Int64 amountBought) {
        this.amountBought = amountBought;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimOfferAtom)) {
            return false;
        }
        ClaimOfferAtom other = (ClaimOfferAtom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$sellerID = this.getSellerID();
        AccountID other$sellerID = other.getSellerID();
        if (this$sellerID == null ? other$sellerID != null : !((Object)this$sellerID).equals(other$sellerID)) {
            return false;
        }
        Int64 this$offerID = this.getOfferID();
        Int64 other$offerID = other.getOfferID();
        if (this$offerID == null ? other$offerID != null : !((Object)this$offerID).equals(other$offerID)) {
            return false;
        }
        Asset this$assetSold = this.getAssetSold();
        Asset other$assetSold = other.getAssetSold();
        if (this$assetSold == null ? other$assetSold != null : !((Object)this$assetSold).equals(other$assetSold)) {
            return false;
        }
        Int64 this$amountSold = this.getAmountSold();
        Int64 other$amountSold = other.getAmountSold();
        if (this$amountSold == null ? other$amountSold != null : !((Object)this$amountSold).equals(other$amountSold)) {
            return false;
        }
        Asset this$assetBought = this.getAssetBought();
        Asset other$assetBought = other.getAssetBought();
        if (this$assetBought == null ? other$assetBought != null : !((Object)this$assetBought).equals(other$assetBought)) {
            return false;
        }
        Int64 this$amountBought = this.getAmountBought();
        Int64 other$amountBought = other.getAmountBought();
        return !(this$amountBought == null ? other$amountBought != null : !((Object)this$amountBought).equals(other$amountBought));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimOfferAtom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $sellerID = this.getSellerID();
        result = result * 59 + ($sellerID == null ? 43 : ((Object)$sellerID).hashCode());
        Int64 $offerID = this.getOfferID();
        result = result * 59 + ($offerID == null ? 43 : ((Object)$offerID).hashCode());
        Asset $assetSold = this.getAssetSold();
        result = result * 59 + ($assetSold == null ? 43 : ((Object)$assetSold).hashCode());
        Int64 $amountSold = this.getAmountSold();
        result = result * 59 + ($amountSold == null ? 43 : ((Object)$amountSold).hashCode());
        Asset $assetBought = this.getAssetBought();
        result = result * 59 + ($assetBought == null ? 43 : ((Object)$assetBought).hashCode());
        Int64 $amountBought = this.getAmountBought();
        result = result * 59 + ($amountBought == null ? 43 : ((Object)$amountBought).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClaimOfferAtom(sellerID=" + this.getSellerID() + ", offerID=" + this.getOfferID() + ", assetSold=" + this.getAssetSold() + ", amountSold=" + this.getAmountSold() + ", assetBought=" + this.getAssetBought() + ", amountBought=" + this.getAmountBought() + ")";
    }

    @Generated
    public ClaimOfferAtom() {
    }

    @Generated
    public ClaimOfferAtom(AccountID sellerID, Int64 offerID, Asset assetSold, Int64 amountSold, Asset assetBought, Int64 amountBought) {
        this.sellerID = sellerID;
        this.offerID = offerID;
        this.assetSold = assetSold;
        this.amountSold = amountSold;
        this.assetBought = assetBought;
        this.amountBought = amountBought;
    }

    @Generated
    public static class ClaimOfferAtomBuilder {
        @Generated
        private AccountID sellerID;
        @Generated
        private Int64 offerID;
        @Generated
        private Asset assetSold;
        @Generated
        private Int64 amountSold;
        @Generated
        private Asset assetBought;
        @Generated
        private Int64 amountBought;

        @Generated
        ClaimOfferAtomBuilder() {
        }

        @Generated
        public ClaimOfferAtomBuilder sellerID(AccountID sellerID) {
            this.sellerID = sellerID;
            return this;
        }

        @Generated
        public ClaimOfferAtomBuilder offerID(Int64 offerID) {
            this.offerID = offerID;
            return this;
        }

        @Generated
        public ClaimOfferAtomBuilder assetSold(Asset assetSold) {
            this.assetSold = assetSold;
            return this;
        }

        @Generated
        public ClaimOfferAtomBuilder amountSold(Int64 amountSold) {
            this.amountSold = amountSold;
            return this;
        }

        @Generated
        public ClaimOfferAtomBuilder assetBought(Asset assetBought) {
            this.assetBought = assetBought;
            return this;
        }

        @Generated
        public ClaimOfferAtomBuilder amountBought(Int64 amountBought) {
            this.amountBought = amountBought;
            return this;
        }

        @Generated
        public ClaimOfferAtom build() {
            return new ClaimOfferAtom(this.sellerID, this.offerID, this.assetSold, this.amountSold, this.assetBought, this.amountBought);
        }

        @Generated
        public String toString() {
            return "ClaimOfferAtom.ClaimOfferAtomBuilder(sellerID=" + this.sellerID + ", offerID=" + this.offerID + ", assetSold=" + this.assetSold + ", amountSold=" + this.amountSold + ", assetBought=" + this.assetBought + ", amountBought=" + this.amountBought + ")";
        }
    }
}

