/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractExecutableType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractExecutable
implements XdrElement {
    private ContractExecutableType discriminant;
    private Hash wasm_hash;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case CONTRACT_EXECUTABLE_WASM: {
                this.wasm_hash.encode(stream);
                break;
            }
        }
    }

    public static ContractExecutable decode(XdrDataInputStream stream) throws IOException {
        ContractExecutable decodedContractExecutable = new ContractExecutable();
        ContractExecutableType discriminant = ContractExecutableType.decode(stream);
        decodedContractExecutable.setDiscriminant(discriminant);
        switch (decodedContractExecutable.getDiscriminant()) {
            case CONTRACT_EXECUTABLE_WASM: {
                decodedContractExecutable.wasm_hash = Hash.decode(stream);
                break;
            }
        }
        return decodedContractExecutable;
    }

    public static ContractExecutable fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractExecutable.fromXdrByteArray(bytes);
    }

    public static ContractExecutable fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractExecutable.decode(xdrDataInputStream);
    }

    @Generated
    public static ContractExecutableBuilder builder() {
        return new ContractExecutableBuilder();
    }

    @Generated
    public ContractExecutableBuilder toBuilder() {
        return new ContractExecutableBuilder().discriminant(this.discriminant).wasm_hash(this.wasm_hash);
    }

    @Generated
    public ContractExecutableType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Hash getWasm_hash() {
        return this.wasm_hash;
    }

    @Generated
    public void setDiscriminant(ContractExecutableType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setWasm_hash(Hash wasm_hash) {
        this.wasm_hash = wasm_hash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractExecutable)) {
            return false;
        }
        ContractExecutable other = (ContractExecutable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContractExecutableType this$discriminant = this.getDiscriminant();
        ContractExecutableType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Hash this$wasm_hash = this.getWasm_hash();
        Hash other$wasm_hash = other.getWasm_hash();
        return !(this$wasm_hash == null ? other$wasm_hash != null : !((Object)this$wasm_hash).equals(other$wasm_hash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContractExecutable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractExecutableType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Hash $wasm_hash = this.getWasm_hash();
        result = result * 59 + ($wasm_hash == null ? 43 : ((Object)$wasm_hash).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractExecutable(discriminant=" + this.getDiscriminant() + ", wasm_hash=" + this.getWasm_hash() + ")";
    }

    @Generated
    public ContractExecutable() {
    }

    @Generated
    public ContractExecutable(ContractExecutableType discriminant, Hash wasm_hash) {
        this.discriminant = discriminant;
        this.wasm_hash = wasm_hash;
    }

    @Generated
    public static class ContractExecutableBuilder {
        @Generated
        private ContractExecutableType discriminant;
        @Generated
        private Hash wasm_hash;

        @Generated
        ContractExecutableBuilder() {
        }

        @Generated
        public ContractExecutableBuilder discriminant(ContractExecutableType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public ContractExecutableBuilder wasm_hash(Hash wasm_hash) {
            this.wasm_hash = wasm_hash;
            return this;
        }

        @Generated
        public ContractExecutable build() {
            return new ContractExecutable(this.discriminant, this.wasm_hash);
        }

        @Generated
        public String toString() {
            return "ContractExecutable.ContractExecutableBuilder(discriminant=" + this.discriminant + ", wasm_hash=" + this.wasm_hash + ")";
        }
    }
}

