/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.GeneralizedTransactionSet;
import org.stellar.sdk.xdr.LedgerCloseMetaExt;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerHeaderHistoryEntry;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SCPHistoryEntry;
import org.stellar.sdk.xdr.TransactionResultMeta;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.UpgradeEntryMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerCloseMetaV1
implements XdrElement {
    private LedgerCloseMetaExt ext;
    private LedgerHeaderHistoryEntry ledgerHeader;
    private GeneralizedTransactionSet txSet;
    private TransactionResultMeta[] txProcessing;
    private UpgradeEntryMeta[] upgradesProcessing;
    private SCPHistoryEntry[] scpInfo;
    private Uint64 totalByteSizeOfLiveSorobanState;
    private LedgerKey[] evictedKeys;
    private LedgerEntry[] unused;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.ledgerHeader.encode(stream);
        this.txSet.encode(stream);
        int txProcessingSize = this.getTxProcessing().length;
        stream.writeInt(txProcessingSize);
        for (int i = 0; i < txProcessingSize; ++i) {
            this.txProcessing[i].encode(stream);
        }
        int upgradesProcessingSize = this.getUpgradesProcessing().length;
        stream.writeInt(upgradesProcessingSize);
        for (int i = 0; i < upgradesProcessingSize; ++i) {
            this.upgradesProcessing[i].encode(stream);
        }
        int scpInfoSize = this.getScpInfo().length;
        stream.writeInt(scpInfoSize);
        for (int i = 0; i < scpInfoSize; ++i) {
            this.scpInfo[i].encode(stream);
        }
        this.totalByteSizeOfLiveSorobanState.encode(stream);
        int evictedKeysSize = this.getEvictedKeys().length;
        stream.writeInt(evictedKeysSize);
        for (int i = 0; i < evictedKeysSize; ++i) {
            this.evictedKeys[i].encode(stream);
        }
        int unusedSize = this.getUnused().length;
        stream.writeInt(unusedSize);
        for (int i = 0; i < unusedSize; ++i) {
            this.unused[i].encode(stream);
        }
    }

    public static LedgerCloseMetaV1 decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseMetaV1 decodedLedgerCloseMetaV1 = new LedgerCloseMetaV1();
        decodedLedgerCloseMetaV1.ext = LedgerCloseMetaExt.decode(stream);
        decodedLedgerCloseMetaV1.ledgerHeader = LedgerHeaderHistoryEntry.decode(stream);
        decodedLedgerCloseMetaV1.txSet = GeneralizedTransactionSet.decode(stream);
        int txProcessingSize = stream.readInt();
        decodedLedgerCloseMetaV1.txProcessing = new TransactionResultMeta[txProcessingSize];
        for (int i = 0; i < txProcessingSize; ++i) {
            decodedLedgerCloseMetaV1.txProcessing[i] = TransactionResultMeta.decode(stream);
        }
        int upgradesProcessingSize = stream.readInt();
        decodedLedgerCloseMetaV1.upgradesProcessing = new UpgradeEntryMeta[upgradesProcessingSize];
        for (int i = 0; i < upgradesProcessingSize; ++i) {
            decodedLedgerCloseMetaV1.upgradesProcessing[i] = UpgradeEntryMeta.decode(stream);
        }
        int scpInfoSize = stream.readInt();
        decodedLedgerCloseMetaV1.scpInfo = new SCPHistoryEntry[scpInfoSize];
        for (int i = 0; i < scpInfoSize; ++i) {
            decodedLedgerCloseMetaV1.scpInfo[i] = SCPHistoryEntry.decode(stream);
        }
        decodedLedgerCloseMetaV1.totalByteSizeOfLiveSorobanState = Uint64.decode(stream);
        int evictedKeysSize = stream.readInt();
        decodedLedgerCloseMetaV1.evictedKeys = new LedgerKey[evictedKeysSize];
        for (int i = 0; i < evictedKeysSize; ++i) {
            decodedLedgerCloseMetaV1.evictedKeys[i] = LedgerKey.decode(stream);
        }
        int unusedSize = stream.readInt();
        decodedLedgerCloseMetaV1.unused = new LedgerEntry[unusedSize];
        for (int i = 0; i < unusedSize; ++i) {
            decodedLedgerCloseMetaV1.unused[i] = LedgerEntry.decode(stream);
        }
        return decodedLedgerCloseMetaV1;
    }

    public static LedgerCloseMetaV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerCloseMetaV1.fromXdrByteArray(bytes);
    }

    public static LedgerCloseMetaV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerCloseMetaV1.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerCloseMetaV1Builder builder() {
        return new LedgerCloseMetaV1Builder();
    }

    @Generated
    public LedgerCloseMetaV1Builder toBuilder() {
        return new LedgerCloseMetaV1Builder().ext(this.ext).ledgerHeader(this.ledgerHeader).txSet(this.txSet).txProcessing(this.txProcessing).upgradesProcessing(this.upgradesProcessing).scpInfo(this.scpInfo).totalByteSizeOfLiveSorobanState(this.totalByteSizeOfLiveSorobanState).evictedKeys(this.evictedKeys).unused(this.unused);
    }

    @Generated
    public LedgerCloseMetaExt getExt() {
        return this.ext;
    }

    @Generated
    public LedgerHeaderHistoryEntry getLedgerHeader() {
        return this.ledgerHeader;
    }

    @Generated
    public GeneralizedTransactionSet getTxSet() {
        return this.txSet;
    }

    @Generated
    public TransactionResultMeta[] getTxProcessing() {
        return this.txProcessing;
    }

    @Generated
    public UpgradeEntryMeta[] getUpgradesProcessing() {
        return this.upgradesProcessing;
    }

    @Generated
    public SCPHistoryEntry[] getScpInfo() {
        return this.scpInfo;
    }

    @Generated
    public Uint64 getTotalByteSizeOfLiveSorobanState() {
        return this.totalByteSizeOfLiveSorobanState;
    }

    @Generated
    public LedgerKey[] getEvictedKeys() {
        return this.evictedKeys;
    }

    @Generated
    public LedgerEntry[] getUnused() {
        return this.unused;
    }

    @Generated
    public void setExt(LedgerCloseMetaExt ext) {
        this.ext = ext;
    }

    @Generated
    public void setLedgerHeader(LedgerHeaderHistoryEntry ledgerHeader) {
        this.ledgerHeader = ledgerHeader;
    }

    @Generated
    public void setTxSet(GeneralizedTransactionSet txSet) {
        this.txSet = txSet;
    }

    @Generated
    public void setTxProcessing(TransactionResultMeta[] txProcessing) {
        this.txProcessing = txProcessing;
    }

    @Generated
    public void setUpgradesProcessing(UpgradeEntryMeta[] upgradesProcessing) {
        this.upgradesProcessing = upgradesProcessing;
    }

    @Generated
    public void setScpInfo(SCPHistoryEntry[] scpInfo) {
        this.scpInfo = scpInfo;
    }

    @Generated
    public void setTotalByteSizeOfLiveSorobanState(Uint64 totalByteSizeOfLiveSorobanState) {
        this.totalByteSizeOfLiveSorobanState = totalByteSizeOfLiveSorobanState;
    }

    @Generated
    public void setEvictedKeys(LedgerKey[] evictedKeys) {
        this.evictedKeys = evictedKeys;
    }

    @Generated
    public void setUnused(LedgerEntry[] unused) {
        this.unused = unused;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerCloseMetaV1)) {
            return false;
        }
        LedgerCloseMetaV1 other = (LedgerCloseMetaV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerCloseMetaExt this$ext = this.getExt();
        LedgerCloseMetaExt other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        LedgerHeaderHistoryEntry this$ledgerHeader = this.getLedgerHeader();
        LedgerHeaderHistoryEntry other$ledgerHeader = other.getLedgerHeader();
        if (this$ledgerHeader == null ? other$ledgerHeader != null : !((Object)this$ledgerHeader).equals(other$ledgerHeader)) {
            return false;
        }
        GeneralizedTransactionSet this$txSet = this.getTxSet();
        GeneralizedTransactionSet other$txSet = other.getTxSet();
        if (this$txSet == null ? other$txSet != null : !((Object)this$txSet).equals(other$txSet)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTxProcessing(), other.getTxProcessing())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUpgradesProcessing(), other.getUpgradesProcessing())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScpInfo(), other.getScpInfo())) {
            return false;
        }
        Uint64 this$totalByteSizeOfLiveSorobanState = this.getTotalByteSizeOfLiveSorobanState();
        Uint64 other$totalByteSizeOfLiveSorobanState = other.getTotalByteSizeOfLiveSorobanState();
        if (this$totalByteSizeOfLiveSorobanState == null ? other$totalByteSizeOfLiveSorobanState != null : !((Object)this$totalByteSizeOfLiveSorobanState).equals(other$totalByteSizeOfLiveSorobanState)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEvictedKeys(), other.getEvictedKeys())) {
            return false;
        }
        return Arrays.deepEquals(this.getUnused(), other.getUnused());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerCloseMetaV1;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerCloseMetaExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        LedgerHeaderHistoryEntry $ledgerHeader = this.getLedgerHeader();
        result = result * 59 + ($ledgerHeader == null ? 43 : ((Object)$ledgerHeader).hashCode());
        GeneralizedTransactionSet $txSet = this.getTxSet();
        result = result * 59 + ($txSet == null ? 43 : ((Object)$txSet).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTxProcessing());
        result = result * 59 + Arrays.deepHashCode(this.getUpgradesProcessing());
        result = result * 59 + Arrays.deepHashCode(this.getScpInfo());
        Uint64 $totalByteSizeOfLiveSorobanState = this.getTotalByteSizeOfLiveSorobanState();
        result = result * 59 + ($totalByteSizeOfLiveSorobanState == null ? 43 : ((Object)$totalByteSizeOfLiveSorobanState).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEvictedKeys());
        result = result * 59 + Arrays.deepHashCode(this.getUnused());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerCloseMetaV1(ext=" + this.getExt() + ", ledgerHeader=" + this.getLedgerHeader() + ", txSet=" + this.getTxSet() + ", txProcessing=" + Arrays.deepToString(this.getTxProcessing()) + ", upgradesProcessing=" + Arrays.deepToString(this.getUpgradesProcessing()) + ", scpInfo=" + Arrays.deepToString(this.getScpInfo()) + ", totalByteSizeOfLiveSorobanState=" + this.getTotalByteSizeOfLiveSorobanState() + ", evictedKeys=" + Arrays.deepToString(this.getEvictedKeys()) + ", unused=" + Arrays.deepToString(this.getUnused()) + ")";
    }

    @Generated
    public LedgerCloseMetaV1() {
    }

    @Generated
    public LedgerCloseMetaV1(LedgerCloseMetaExt ext, LedgerHeaderHistoryEntry ledgerHeader, GeneralizedTransactionSet txSet, TransactionResultMeta[] txProcessing, UpgradeEntryMeta[] upgradesProcessing, SCPHistoryEntry[] scpInfo, Uint64 totalByteSizeOfLiveSorobanState, LedgerKey[] evictedKeys, LedgerEntry[] unused) {
        this.ext = ext;
        this.ledgerHeader = ledgerHeader;
        this.txSet = txSet;
        this.txProcessing = txProcessing;
        this.upgradesProcessing = upgradesProcessing;
        this.scpInfo = scpInfo;
        this.totalByteSizeOfLiveSorobanState = totalByteSizeOfLiveSorobanState;
        this.evictedKeys = evictedKeys;
        this.unused = unused;
    }

    @Generated
    public static class LedgerCloseMetaV1Builder {
        @Generated
        private LedgerCloseMetaExt ext;
        @Generated
        private LedgerHeaderHistoryEntry ledgerHeader;
        @Generated
        private GeneralizedTransactionSet txSet;
        @Generated
        private TransactionResultMeta[] txProcessing;
        @Generated
        private UpgradeEntryMeta[] upgradesProcessing;
        @Generated
        private SCPHistoryEntry[] scpInfo;
        @Generated
        private Uint64 totalByteSizeOfLiveSorobanState;
        @Generated
        private LedgerKey[] evictedKeys;
        @Generated
        private LedgerEntry[] unused;

        @Generated
        LedgerCloseMetaV1Builder() {
        }

        @Generated
        public LedgerCloseMetaV1Builder ext(LedgerCloseMetaExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder ledgerHeader(LedgerHeaderHistoryEntry ledgerHeader) {
            this.ledgerHeader = ledgerHeader;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder txSet(GeneralizedTransactionSet txSet) {
            this.txSet = txSet;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder txProcessing(TransactionResultMeta[] txProcessing) {
            this.txProcessing = txProcessing;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder upgradesProcessing(UpgradeEntryMeta[] upgradesProcessing) {
            this.upgradesProcessing = upgradesProcessing;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder scpInfo(SCPHistoryEntry[] scpInfo) {
            this.scpInfo = scpInfo;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder totalByteSizeOfLiveSorobanState(Uint64 totalByteSizeOfLiveSorobanState) {
            this.totalByteSizeOfLiveSorobanState = totalByteSizeOfLiveSorobanState;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder evictedKeys(LedgerKey[] evictedKeys) {
            this.evictedKeys = evictedKeys;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder unused(LedgerEntry[] unused) {
            this.unused = unused;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1 build() {
            return new LedgerCloseMetaV1(this.ext, this.ledgerHeader, this.txSet, this.txProcessing, this.upgradesProcessing, this.scpInfo, this.totalByteSizeOfLiveSorobanState, this.evictedKeys, this.unused);
        }

        @Generated
        public String toString() {
            return "LedgerCloseMetaV1.LedgerCloseMetaV1Builder(ext=" + this.ext + ", ledgerHeader=" + this.ledgerHeader + ", txSet=" + this.txSet + ", txProcessing=" + Arrays.deepToString(this.txProcessing) + ", upgradesProcessing=" + Arrays.deepToString(this.upgradesProcessing) + ", scpInfo=" + Arrays.deepToString(this.scpInfo) + ", totalByteSizeOfLiveSorobanState=" + this.totalByteSizeOfLiveSorobanState + ", evictedKeys=" + Arrays.deepToString(this.evictedKeys) + ", unused=" + Arrays.deepToString(this.unused) + ")";
        }
    }
}

