/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerEntryChangeType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerEntryChange
implements XdrElement {
    private LedgerEntryChangeType discriminant;
    private LedgerEntry created;
    private LedgerEntry updated;
    private LedgerKey removed;
    private LedgerEntry state;
    private LedgerEntry restored;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case LEDGER_ENTRY_CREATED: {
                this.created.encode(stream);
                break;
            }
            case LEDGER_ENTRY_UPDATED: {
                this.updated.encode(stream);
                break;
            }
            case LEDGER_ENTRY_REMOVED: {
                this.removed.encode(stream);
                break;
            }
            case LEDGER_ENTRY_STATE: {
                this.state.encode(stream);
                break;
            }
            case LEDGER_ENTRY_RESTORED: {
                this.restored.encode(stream);
            }
        }
    }

    public static LedgerEntryChange decode(XdrDataInputStream stream) throws IOException {
        LedgerEntryChange decodedLedgerEntryChange = new LedgerEntryChange();
        LedgerEntryChangeType discriminant = LedgerEntryChangeType.decode(stream);
        decodedLedgerEntryChange.setDiscriminant(discriminant);
        switch (decodedLedgerEntryChange.getDiscriminant()) {
            case LEDGER_ENTRY_CREATED: {
                decodedLedgerEntryChange.created = LedgerEntry.decode(stream);
                break;
            }
            case LEDGER_ENTRY_UPDATED: {
                decodedLedgerEntryChange.updated = LedgerEntry.decode(stream);
                break;
            }
            case LEDGER_ENTRY_REMOVED: {
                decodedLedgerEntryChange.removed = LedgerKey.decode(stream);
                break;
            }
            case LEDGER_ENTRY_STATE: {
                decodedLedgerEntryChange.state = LedgerEntry.decode(stream);
                break;
            }
            case LEDGER_ENTRY_RESTORED: {
                decodedLedgerEntryChange.restored = LedgerEntry.decode(stream);
            }
        }
        return decodedLedgerEntryChange;
    }

    public static LedgerEntryChange fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerEntryChange.fromXdrByteArray(bytes);
    }

    public static LedgerEntryChange fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerEntryChange.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerEntryChangeBuilder builder() {
        return new LedgerEntryChangeBuilder();
    }

    @Generated
    public LedgerEntryChangeBuilder toBuilder() {
        return new LedgerEntryChangeBuilder().discriminant(this.discriminant).created(this.created).updated(this.updated).removed(this.removed).state(this.state).restored(this.restored);
    }

    @Generated
    public LedgerEntryChangeType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public LedgerEntry getCreated() {
        return this.created;
    }

    @Generated
    public LedgerEntry getUpdated() {
        return this.updated;
    }

    @Generated
    public LedgerKey getRemoved() {
        return this.removed;
    }

    @Generated
    public LedgerEntry getState() {
        return this.state;
    }

    @Generated
    public LedgerEntry getRestored() {
        return this.restored;
    }

    @Generated
    public void setDiscriminant(LedgerEntryChangeType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setCreated(LedgerEntry created) {
        this.created = created;
    }

    @Generated
    public void setUpdated(LedgerEntry updated) {
        this.updated = updated;
    }

    @Generated
    public void setRemoved(LedgerKey removed) {
        this.removed = removed;
    }

    @Generated
    public void setState(LedgerEntry state) {
        this.state = state;
    }

    @Generated
    public void setRestored(LedgerEntry restored) {
        this.restored = restored;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerEntryChange)) {
            return false;
        }
        LedgerEntryChange other = (LedgerEntryChange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerEntryChangeType this$discriminant = this.getDiscriminant();
        LedgerEntryChangeType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        LedgerEntry this$created = this.getCreated();
        LedgerEntry other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        LedgerEntry this$updated = this.getUpdated();
        LedgerEntry other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        LedgerKey this$removed = this.getRemoved();
        LedgerKey other$removed = other.getRemoved();
        if (this$removed == null ? other$removed != null : !((Object)this$removed).equals(other$removed)) {
            return false;
        }
        LedgerEntry this$state = this.getState();
        LedgerEntry other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        LedgerEntry this$restored = this.getRestored();
        LedgerEntry other$restored = other.getRestored();
        return !(this$restored == null ? other$restored != null : !((Object)this$restored).equals(other$restored));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerEntryChange;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerEntryChangeType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        LedgerEntry $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        LedgerEntry $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        LedgerKey $removed = this.getRemoved();
        result = result * 59 + ($removed == null ? 43 : ((Object)$removed).hashCode());
        LedgerEntry $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        LedgerEntry $restored = this.getRestored();
        result = result * 59 + ($restored == null ? 43 : ((Object)$restored).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerEntryChange(discriminant=" + this.getDiscriminant() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", removed=" + this.getRemoved() + ", state=" + this.getState() + ", restored=" + this.getRestored() + ")";
    }

    @Generated
    public LedgerEntryChange() {
    }

    @Generated
    public LedgerEntryChange(LedgerEntryChangeType discriminant, LedgerEntry created, LedgerEntry updated, LedgerKey removed, LedgerEntry state, LedgerEntry restored) {
        this.discriminant = discriminant;
        this.created = created;
        this.updated = updated;
        this.removed = removed;
        this.state = state;
        this.restored = restored;
    }

    @Generated
    public static class LedgerEntryChangeBuilder {
        @Generated
        private LedgerEntryChangeType discriminant;
        @Generated
        private LedgerEntry created;
        @Generated
        private LedgerEntry updated;
        @Generated
        private LedgerKey removed;
        @Generated
        private LedgerEntry state;
        @Generated
        private LedgerEntry restored;

        @Generated
        LedgerEntryChangeBuilder() {
        }

        @Generated
        public LedgerEntryChangeBuilder discriminant(LedgerEntryChangeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public LedgerEntryChangeBuilder created(LedgerEntry created) {
            this.created = created;
            return this;
        }

        @Generated
        public LedgerEntryChangeBuilder updated(LedgerEntry updated) {
            this.updated = updated;
            return this;
        }

        @Generated
        public LedgerEntryChangeBuilder removed(LedgerKey removed) {
            this.removed = removed;
            return this;
        }

        @Generated
        public LedgerEntryChangeBuilder state(LedgerEntry state) {
            this.state = state;
            return this;
        }

        @Generated
        public LedgerEntryChangeBuilder restored(LedgerEntry restored) {
            this.restored = restored;
            return this;
        }

        @Generated
        public LedgerEntryChange build() {
            return new LedgerEntryChange(this.discriminant, this.created, this.updated, this.removed, this.state, this.restored);
        }

        @Generated
        public String toString() {
            return "LedgerEntryChange.LedgerEntryChangeBuilder(discriminant=" + this.discriminant + ", created=" + this.created + ", updated=" + this.updated + ", removed=" + this.removed + ", state=" + this.state + ", restored=" + this.restored + ")";
        }
    }
}

