/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerEntryChangeType implements XdrElement
{
    LEDGER_ENTRY_CREATED(0),
    LEDGER_ENTRY_UPDATED(1),
    LEDGER_ENTRY_REMOVED(2),
    LEDGER_ENTRY_STATE(3),
    LEDGER_ENTRY_RESTORED(4);

    private final int value;

    private LedgerEntryChangeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LedgerEntryChangeType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return LEDGER_ENTRY_CREATED;
            }
            case 1: {
                return LEDGER_ENTRY_UPDATED;
            }
            case 2: {
                return LEDGER_ENTRY_REMOVED;
            }
            case 3: {
                return LEDGER_ENTRY_STATE;
            }
            case 4: {
                return LEDGER_ENTRY_RESTORED;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static LedgerEntryChangeType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerEntryChangeType.fromXdrByteArray(bytes);
    }

    public static LedgerEntryChangeType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerEntryChangeType.decode(xdrDataInputStream);
    }
}

