/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCPEnvelope;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerSCPMessages
implements XdrElement {
    private Uint32 ledgerSeq;
    private SCPEnvelope[] messages;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ledgerSeq.encode(stream);
        int messagesSize = this.getMessages().length;
        stream.writeInt(messagesSize);
        for (int i = 0; i < messagesSize; ++i) {
            this.messages[i].encode(stream);
        }
    }

    public static LedgerSCPMessages decode(XdrDataInputStream stream) throws IOException {
        LedgerSCPMessages decodedLedgerSCPMessages = new LedgerSCPMessages();
        decodedLedgerSCPMessages.ledgerSeq = Uint32.decode(stream);
        int messagesSize = stream.readInt();
        decodedLedgerSCPMessages.messages = new SCPEnvelope[messagesSize];
        for (int i = 0; i < messagesSize; ++i) {
            decodedLedgerSCPMessages.messages[i] = SCPEnvelope.decode(stream);
        }
        return decodedLedgerSCPMessages;
    }

    public static LedgerSCPMessages fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerSCPMessages.fromXdrByteArray(bytes);
    }

    public static LedgerSCPMessages fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerSCPMessages.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerSCPMessagesBuilder builder() {
        return new LedgerSCPMessagesBuilder();
    }

    @Generated
    public LedgerSCPMessagesBuilder toBuilder() {
        return new LedgerSCPMessagesBuilder().ledgerSeq(this.ledgerSeq).messages(this.messages);
    }

    @Generated
    public Uint32 getLedgerSeq() {
        return this.ledgerSeq;
    }

    @Generated
    public SCPEnvelope[] getMessages() {
        return this.messages;
    }

    @Generated
    public void setLedgerSeq(Uint32 ledgerSeq) {
        this.ledgerSeq = ledgerSeq;
    }

    @Generated
    public void setMessages(SCPEnvelope[] messages) {
        this.messages = messages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerSCPMessages)) {
            return false;
        }
        LedgerSCPMessages other = (LedgerSCPMessages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$ledgerSeq = this.getLedgerSeq();
        Uint32 other$ledgerSeq = other.getLedgerSeq();
        if (this$ledgerSeq == null ? other$ledgerSeq != null : !((Object)this$ledgerSeq).equals(other$ledgerSeq)) {
            return false;
        }
        return Arrays.deepEquals(this.getMessages(), other.getMessages());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerSCPMessages;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $ledgerSeq = this.getLedgerSeq();
        result = result * 59 + ($ledgerSeq == null ? 43 : ((Object)$ledgerSeq).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMessages());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerSCPMessages(ledgerSeq=" + this.getLedgerSeq() + ", messages=" + Arrays.deepToString(this.getMessages()) + ")";
    }

    @Generated
    public LedgerSCPMessages() {
    }

    @Generated
    public LedgerSCPMessages(Uint32 ledgerSeq, SCPEnvelope[] messages) {
        this.ledgerSeq = ledgerSeq;
        this.messages = messages;
    }

    @Generated
    public static class LedgerSCPMessagesBuilder {
        @Generated
        private Uint32 ledgerSeq;
        @Generated
        private SCPEnvelope[] messages;

        @Generated
        LedgerSCPMessagesBuilder() {
        }

        @Generated
        public LedgerSCPMessagesBuilder ledgerSeq(Uint32 ledgerSeq) {
            this.ledgerSeq = ledgerSeq;
            return this;
        }

        @Generated
        public LedgerSCPMessagesBuilder messages(SCPEnvelope[] messages) {
            this.messages = messages;
            return this;
        }

        @Generated
        public LedgerSCPMessages build() {
            return new LedgerSCPMessages(this.ledgerSeq, this.messages);
        }

        @Generated
        public String toString() {
            return "LedgerSCPMessages.LedgerSCPMessagesBuilder(ledgerSeq=" + this.ledgerSeq + ", messages=" + Arrays.deepToString(this.messages) + ")";
        }
    }
}

