/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class MuxedAccount
implements XdrElement {
    private CryptoKeyType discriminant;
    private Uint256 ed25519;
    private MuxedAccountMed25519 med25519;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case KEY_TYPE_ED25519: {
                this.ed25519.encode(stream);
                break;
            }
            case KEY_TYPE_MUXED_ED25519: {
                this.med25519.encode(stream);
            }
        }
    }

    public static MuxedAccount decode(XdrDataInputStream stream) throws IOException {
        MuxedAccount decodedMuxedAccount = new MuxedAccount();
        CryptoKeyType discriminant = CryptoKeyType.decode(stream);
        decodedMuxedAccount.setDiscriminant(discriminant);
        switch (decodedMuxedAccount.getDiscriminant()) {
            case KEY_TYPE_ED25519: {
                decodedMuxedAccount.ed25519 = Uint256.decode(stream);
                break;
            }
            case KEY_TYPE_MUXED_ED25519: {
                decodedMuxedAccount.med25519 = MuxedAccountMed25519.decode(stream);
            }
        }
        return decodedMuxedAccount;
    }

    public static MuxedAccount fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return MuxedAccount.fromXdrByteArray(bytes);
    }

    public static MuxedAccount fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return MuxedAccount.decode(xdrDataInputStream);
    }

    @Generated
    public static MuxedAccountBuilder builder() {
        return new MuxedAccountBuilder();
    }

    @Generated
    public MuxedAccountBuilder toBuilder() {
        return new MuxedAccountBuilder().discriminant(this.discriminant).ed25519(this.ed25519).med25519(this.med25519);
    }

    @Generated
    public CryptoKeyType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Uint256 getEd25519() {
        return this.ed25519;
    }

    @Generated
    public MuxedAccountMed25519 getMed25519() {
        return this.med25519;
    }

    @Generated
    public void setDiscriminant(CryptoKeyType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setEd25519(Uint256 ed25519) {
        this.ed25519 = ed25519;
    }

    @Generated
    public void setMed25519(MuxedAccountMed25519 med25519) {
        this.med25519 = med25519;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MuxedAccount)) {
            return false;
        }
        MuxedAccount other = (MuxedAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CryptoKeyType this$discriminant = this.getDiscriminant();
        CryptoKeyType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Uint256 this$ed25519 = this.getEd25519();
        Uint256 other$ed25519 = other.getEd25519();
        if (this$ed25519 == null ? other$ed25519 != null : !((Object)this$ed25519).equals(other$ed25519)) {
            return false;
        }
        MuxedAccountMed25519 this$med25519 = this.getMed25519();
        MuxedAccountMed25519 other$med25519 = other.getMed25519();
        return !(this$med25519 == null ? other$med25519 != null : !((Object)this$med25519).equals(other$med25519));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MuxedAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CryptoKeyType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Uint256 $ed25519 = this.getEd25519();
        result = result * 59 + ($ed25519 == null ? 43 : ((Object)$ed25519).hashCode());
        MuxedAccountMed25519 $med25519 = this.getMed25519();
        result = result * 59 + ($med25519 == null ? 43 : ((Object)$med25519).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MuxedAccount(discriminant=" + this.getDiscriminant() + ", ed25519=" + this.getEd25519() + ", med25519=" + this.getMed25519() + ")";
    }

    @Generated
    public MuxedAccount() {
    }

    @Generated
    public MuxedAccount(CryptoKeyType discriminant, Uint256 ed25519, MuxedAccountMed25519 med25519) {
        this.discriminant = discriminant;
        this.ed25519 = ed25519;
        this.med25519 = med25519;
    }

    @Generated
    public static class MuxedAccountBuilder {
        @Generated
        private CryptoKeyType discriminant;
        @Generated
        private Uint256 ed25519;
        @Generated
        private MuxedAccountMed25519 med25519;

        @Generated
        MuxedAccountBuilder() {
        }

        @Generated
        public MuxedAccountBuilder discriminant(CryptoKeyType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public MuxedAccountBuilder ed25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
            return this;
        }

        @Generated
        public MuxedAccountBuilder med25519(MuxedAccountMed25519 med25519) {
            this.med25519 = med25519;
            return this;
        }

        @Generated
        public MuxedAccount build() {
            return new MuxedAccount(this.discriminant, this.ed25519, this.med25519);
        }

        @Generated
        public String toString() {
            return "MuxedAccount.MuxedAccountBuilder(discriminant=" + this.discriminant + ", ed25519=" + this.ed25519 + ", med25519=" + this.med25519 + ")";
        }
    }

    public static class MuxedAccountMed25519
    implements XdrElement {
        private Uint64 id;
        private Uint256 ed25519;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.id.encode(stream);
            this.ed25519.encode(stream);
        }

        public static MuxedAccountMed25519 decode(XdrDataInputStream stream) throws IOException {
            MuxedAccountMed25519 decodedMuxedAccountMed25519 = new MuxedAccountMed25519();
            decodedMuxedAccountMed25519.id = Uint64.decode(stream);
            decodedMuxedAccountMed25519.ed25519 = Uint256.decode(stream);
            return decodedMuxedAccountMed25519;
        }

        public static MuxedAccountMed25519 fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return MuxedAccountMed25519.fromXdrByteArray(bytes);
        }

        public static MuxedAccountMed25519 fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return MuxedAccountMed25519.decode(xdrDataInputStream);
        }

        @Generated
        public static MuxedAccountMed25519Builder builder() {
            return new MuxedAccountMed25519Builder();
        }

        @Generated
        public MuxedAccountMed25519Builder toBuilder() {
            return new MuxedAccountMed25519Builder().id(this.id).ed25519(this.ed25519);
        }

        @Generated
        public Uint64 getId() {
            return this.id;
        }

        @Generated
        public Uint256 getEd25519() {
            return this.ed25519;
        }

        @Generated
        public void setId(Uint64 id) {
            this.id = id;
        }

        @Generated
        public void setEd25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MuxedAccountMed25519)) {
                return false;
            }
            MuxedAccountMed25519 other = (MuxedAccountMed25519)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Uint64 this$id = this.getId();
            Uint64 other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Uint256 this$ed25519 = this.getEd25519();
            Uint256 other$ed25519 = other.getEd25519();
            return !(this$ed25519 == null ? other$ed25519 != null : !((Object)this$ed25519).equals(other$ed25519));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MuxedAccountMed25519;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Uint64 $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Uint256 $ed25519 = this.getEd25519();
            result = result * 59 + ($ed25519 == null ? 43 : ((Object)$ed25519).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MuxedAccount.MuxedAccountMed25519(id=" + this.getId() + ", ed25519=" + this.getEd25519() + ")";
        }

        @Generated
        public MuxedAccountMed25519() {
        }

        @Generated
        public MuxedAccountMed25519(Uint64 id, Uint256 ed25519) {
            this.id = id;
            this.ed25519 = ed25519;
        }

        @Generated
        public static class MuxedAccountMed25519Builder {
            @Generated
            private Uint64 id;
            @Generated
            private Uint256 ed25519;

            @Generated
            MuxedAccountMed25519Builder() {
            }

            @Generated
            public MuxedAccountMed25519Builder id(Uint64 id) {
                this.id = id;
                return this;
            }

            @Generated
            public MuxedAccountMed25519Builder ed25519(Uint256 ed25519) {
                this.ed25519 = ed25519;
                return this;
            }

            @Generated
            public MuxedAccountMed25519 build() {
                return new MuxedAccountMed25519(this.id, this.ed25519);
            }

            @Generated
            public String toString() {
                return "MuxedAccount.MuxedAccountMed25519.MuxedAccountMed25519Builder(id=" + this.id + ", ed25519=" + this.ed25519 + ")";
            }
        }
    }
}

