/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Value;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPNomination
implements XdrElement {
    private Hash quorumSetHash;
    private Value[] votes;
    private Value[] accepted;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.quorumSetHash.encode(stream);
        int votesSize = this.getVotes().length;
        stream.writeInt(votesSize);
        for (int i = 0; i < votesSize; ++i) {
            this.votes[i].encode(stream);
        }
        int acceptedSize = this.getAccepted().length;
        stream.writeInt(acceptedSize);
        for (int i = 0; i < acceptedSize; ++i) {
            this.accepted[i].encode(stream);
        }
    }

    public static SCPNomination decode(XdrDataInputStream stream) throws IOException {
        SCPNomination decodedSCPNomination = new SCPNomination();
        decodedSCPNomination.quorumSetHash = Hash.decode(stream);
        int votesSize = stream.readInt();
        decodedSCPNomination.votes = new Value[votesSize];
        for (int i = 0; i < votesSize; ++i) {
            decodedSCPNomination.votes[i] = Value.decode(stream);
        }
        int acceptedSize = stream.readInt();
        decodedSCPNomination.accepted = new Value[acceptedSize];
        for (int i = 0; i < acceptedSize; ++i) {
            decodedSCPNomination.accepted[i] = Value.decode(stream);
        }
        return decodedSCPNomination;
    }

    public static SCPNomination fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPNomination.fromXdrByteArray(bytes);
    }

    public static SCPNomination fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPNomination.decode(xdrDataInputStream);
    }

    @Generated
    public static SCPNominationBuilder builder() {
        return new SCPNominationBuilder();
    }

    @Generated
    public SCPNominationBuilder toBuilder() {
        return new SCPNominationBuilder().quorumSetHash(this.quorumSetHash).votes(this.votes).accepted(this.accepted);
    }

    @Generated
    public Hash getQuorumSetHash() {
        return this.quorumSetHash;
    }

    @Generated
    public Value[] getVotes() {
        return this.votes;
    }

    @Generated
    public Value[] getAccepted() {
        return this.accepted;
    }

    @Generated
    public void setQuorumSetHash(Hash quorumSetHash) {
        this.quorumSetHash = quorumSetHash;
    }

    @Generated
    public void setVotes(Value[] votes) {
        this.votes = votes;
    }

    @Generated
    public void setAccepted(Value[] accepted) {
        this.accepted = accepted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCPNomination)) {
            return false;
        }
        SCPNomination other = (SCPNomination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$quorumSetHash = this.getQuorumSetHash();
        Hash other$quorumSetHash = other.getQuorumSetHash();
        if (this$quorumSetHash == null ? other$quorumSetHash != null : !((Object)this$quorumSetHash).equals(other$quorumSetHash)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVotes(), other.getVotes())) {
            return false;
        }
        return Arrays.deepEquals(this.getAccepted(), other.getAccepted());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCPNomination;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $quorumSetHash = this.getQuorumSetHash();
        result = result * 59 + ($quorumSetHash == null ? 43 : ((Object)$quorumSetHash).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getVotes());
        result = result * 59 + Arrays.deepHashCode(this.getAccepted());
        return result;
    }

    @Generated
    public String toString() {
        return "SCPNomination(quorumSetHash=" + this.getQuorumSetHash() + ", votes=" + Arrays.deepToString(this.getVotes()) + ", accepted=" + Arrays.deepToString(this.getAccepted()) + ")";
    }

    @Generated
    public SCPNomination() {
    }

    @Generated
    public SCPNomination(Hash quorumSetHash, Value[] votes, Value[] accepted) {
        this.quorumSetHash = quorumSetHash;
        this.votes = votes;
        this.accepted = accepted;
    }

    @Generated
    public static class SCPNominationBuilder {
        @Generated
        private Hash quorumSetHash;
        @Generated
        private Value[] votes;
        @Generated
        private Value[] accepted;

        @Generated
        SCPNominationBuilder() {
        }

        @Generated
        public SCPNominationBuilder quorumSetHash(Hash quorumSetHash) {
            this.quorumSetHash = quorumSetHash;
            return this;
        }

        @Generated
        public SCPNominationBuilder votes(Value[] votes) {
            this.votes = votes;
            return this;
        }

        @Generated
        public SCPNominationBuilder accepted(Value[] accepted) {
            this.accepted = accepted;
            return this;
        }

        @Generated
        public SCPNomination build() {
            return new SCPNomination(this.quorumSetHash, this.votes, this.accepted);
        }

        @Generated
        public String toString() {
            return "SCPNomination.SCPNominationBuilder(quorumSetHash=" + this.quorumSetHash + ", votes=" + Arrays.deepToString(this.votes) + ", accepted=" + Arrays.deepToString(this.accepted) + ")";
        }
    }
}

