/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TimeSlicedSurveyStartCollectingMessage
implements XdrElement {
    private NodeID surveyorID;
    private Uint32 nonce;
    private Uint32 ledgerNum;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.surveyorID.encode(stream);
        this.nonce.encode(stream);
        this.ledgerNum.encode(stream);
    }

    public static TimeSlicedSurveyStartCollectingMessage decode(XdrDataInputStream stream) throws IOException {
        TimeSlicedSurveyStartCollectingMessage decodedTimeSlicedSurveyStartCollectingMessage = new TimeSlicedSurveyStartCollectingMessage();
        decodedTimeSlicedSurveyStartCollectingMessage.surveyorID = NodeID.decode(stream);
        decodedTimeSlicedSurveyStartCollectingMessage.nonce = Uint32.decode(stream);
        decodedTimeSlicedSurveyStartCollectingMessage.ledgerNum = Uint32.decode(stream);
        return decodedTimeSlicedSurveyStartCollectingMessage;
    }

    public static TimeSlicedSurveyStartCollectingMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TimeSlicedSurveyStartCollectingMessage.fromXdrByteArray(bytes);
    }

    public static TimeSlicedSurveyStartCollectingMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TimeSlicedSurveyStartCollectingMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static TimeSlicedSurveyStartCollectingMessageBuilder builder() {
        return new TimeSlicedSurveyStartCollectingMessageBuilder();
    }

    @Generated
    public TimeSlicedSurveyStartCollectingMessageBuilder toBuilder() {
        return new TimeSlicedSurveyStartCollectingMessageBuilder().surveyorID(this.surveyorID).nonce(this.nonce).ledgerNum(this.ledgerNum);
    }

    @Generated
    public NodeID getSurveyorID() {
        return this.surveyorID;
    }

    @Generated
    public Uint32 getNonce() {
        return this.nonce;
    }

    @Generated
    public Uint32 getLedgerNum() {
        return this.ledgerNum;
    }

    @Generated
    public void setSurveyorID(NodeID surveyorID) {
        this.surveyorID = surveyorID;
    }

    @Generated
    public void setNonce(Uint32 nonce) {
        this.nonce = nonce;
    }

    @Generated
    public void setLedgerNum(Uint32 ledgerNum) {
        this.ledgerNum = ledgerNum;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSlicedSurveyStartCollectingMessage)) {
            return false;
        }
        TimeSlicedSurveyStartCollectingMessage other = (TimeSlicedSurveyStartCollectingMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeID this$surveyorID = this.getSurveyorID();
        NodeID other$surveyorID = other.getSurveyorID();
        if (this$surveyorID == null ? other$surveyorID != null : !((Object)this$surveyorID).equals(other$surveyorID)) {
            return false;
        }
        Uint32 this$nonce = this.getNonce();
        Uint32 other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Uint32 this$ledgerNum = this.getLedgerNum();
        Uint32 other$ledgerNum = other.getLedgerNum();
        return !(this$ledgerNum == null ? other$ledgerNum != null : !((Object)this$ledgerNum).equals(other$ledgerNum));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeSlicedSurveyStartCollectingMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeID $surveyorID = this.getSurveyorID();
        result = result * 59 + ($surveyorID == null ? 43 : ((Object)$surveyorID).hashCode());
        Uint32 $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Uint32 $ledgerNum = this.getLedgerNum();
        result = result * 59 + ($ledgerNum == null ? 43 : ((Object)$ledgerNum).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeSlicedSurveyStartCollectingMessage(surveyorID=" + this.getSurveyorID() + ", nonce=" + this.getNonce() + ", ledgerNum=" + this.getLedgerNum() + ")";
    }

    @Generated
    public TimeSlicedSurveyStartCollectingMessage() {
    }

    @Generated
    public TimeSlicedSurveyStartCollectingMessage(NodeID surveyorID, Uint32 nonce, Uint32 ledgerNum) {
        this.surveyorID = surveyorID;
        this.nonce = nonce;
        this.ledgerNum = ledgerNum;
    }

    @Generated
    public static class TimeSlicedSurveyStartCollectingMessageBuilder {
        @Generated
        private NodeID surveyorID;
        @Generated
        private Uint32 nonce;
        @Generated
        private Uint32 ledgerNum;

        @Generated
        TimeSlicedSurveyStartCollectingMessageBuilder() {
        }

        @Generated
        public TimeSlicedSurveyStartCollectingMessageBuilder surveyorID(NodeID surveyorID) {
            this.surveyorID = surveyorID;
            return this;
        }

        @Generated
        public TimeSlicedSurveyStartCollectingMessageBuilder nonce(Uint32 nonce) {
            this.nonce = nonce;
            return this;
        }

        @Generated
        public TimeSlicedSurveyStartCollectingMessageBuilder ledgerNum(Uint32 ledgerNum) {
            this.ledgerNum = ledgerNum;
            return this;
        }

        @Generated
        public TimeSlicedSurveyStartCollectingMessage build() {
            return new TimeSlicedSurveyStartCollectingMessage(this.surveyorID, this.nonce, this.ledgerNum);
        }

        @Generated
        public String toString() {
            return "TimeSlicedSurveyStartCollectingMessage.TimeSlicedSurveyStartCollectingMessageBuilder(surveyorID=" + this.surveyorID + ", nonce=" + this.nonce + ", ledgerNum=" + this.ledgerNum + ")";
        }
    }
}

