/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum TransactionEventStage implements XdrElement
{
    TRANSACTION_EVENT_STAGE_BEFORE_ALL_TXS(0),
    TRANSACTION_EVENT_STAGE_AFTER_TX(1),
    TRANSACTION_EVENT_STAGE_AFTER_ALL_TXS(2);

    private final int value;

    private TransactionEventStage(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TransactionEventStage decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return TRANSACTION_EVENT_STAGE_BEFORE_ALL_TXS;
            }
            case 1: {
                return TRANSACTION_EVENT_STAGE_AFTER_TX;
            }
            case 2: {
                return TRANSACTION_EVENT_STAGE_AFTER_ALL_TXS;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static TransactionEventStage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionEventStage.fromXdrByteArray(bytes);
    }

    public static TransactionEventStage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionEventStage.decode(xdrDataInputStream);
    }
}

