/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Liabilities;
import org.stellar.sdk.xdr.TrustLineAsset;
import org.stellar.sdk.xdr.TrustLineEntryExtensionV2;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TrustLineEntry
implements XdrElement {
    private AccountID accountID;
    private TrustLineAsset asset;
    private Int64 balance;
    private Int64 limit;
    private Uint32 flags;
    private TrustLineEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.accountID.encode(stream);
        this.asset.encode(stream);
        this.balance.encode(stream);
        this.limit.encode(stream);
        this.flags.encode(stream);
        this.ext.encode(stream);
    }

    public static TrustLineEntry decode(XdrDataInputStream stream) throws IOException {
        TrustLineEntry decodedTrustLineEntry = new TrustLineEntry();
        decodedTrustLineEntry.accountID = AccountID.decode(stream);
        decodedTrustLineEntry.asset = TrustLineAsset.decode(stream);
        decodedTrustLineEntry.balance = Int64.decode(stream);
        decodedTrustLineEntry.limit = Int64.decode(stream);
        decodedTrustLineEntry.flags = Uint32.decode(stream);
        decodedTrustLineEntry.ext = TrustLineEntryExt.decode(stream);
        return decodedTrustLineEntry;
    }

    public static TrustLineEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TrustLineEntry.fromXdrByteArray(bytes);
    }

    public static TrustLineEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TrustLineEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static TrustLineEntryBuilder builder() {
        return new TrustLineEntryBuilder();
    }

    @Generated
    public TrustLineEntryBuilder toBuilder() {
        return new TrustLineEntryBuilder().accountID(this.accountID).asset(this.asset).balance(this.balance).limit(this.limit).flags(this.flags).ext(this.ext);
    }

    @Generated
    public AccountID getAccountID() {
        return this.accountID;
    }

    @Generated
    public TrustLineAsset getAsset() {
        return this.asset;
    }

    @Generated
    public Int64 getBalance() {
        return this.balance;
    }

    @Generated
    public Int64 getLimit() {
        return this.limit;
    }

    @Generated
    public Uint32 getFlags() {
        return this.flags;
    }

    @Generated
    public TrustLineEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setAccountID(AccountID accountID) {
        this.accountID = accountID;
    }

    @Generated
    public void setAsset(TrustLineAsset asset) {
        this.asset = asset;
    }

    @Generated
    public void setBalance(Int64 balance) {
        this.balance = balance;
    }

    @Generated
    public void setLimit(Int64 limit) {
        this.limit = limit;
    }

    @Generated
    public void setFlags(Uint32 flags) {
        this.flags = flags;
    }

    @Generated
    public void setExt(TrustLineEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustLineEntry)) {
            return false;
        }
        TrustLineEntry other = (TrustLineEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$accountID = this.getAccountID();
        AccountID other$accountID = other.getAccountID();
        if (this$accountID == null ? other$accountID != null : !((Object)this$accountID).equals(other$accountID)) {
            return false;
        }
        TrustLineAsset this$asset = this.getAsset();
        TrustLineAsset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        Int64 this$balance = this.getBalance();
        Int64 other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        Int64 this$limit = this.getLimit();
        Int64 other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Uint32 this$flags = this.getFlags();
        Uint32 other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        TrustLineEntryExt this$ext = this.getExt();
        TrustLineEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrustLineEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $accountID = this.getAccountID();
        result = result * 59 + ($accountID == null ? 43 : ((Object)$accountID).hashCode());
        TrustLineAsset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        Int64 $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        Int64 $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Uint32 $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        TrustLineEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TrustLineEntry(accountID=" + this.getAccountID() + ", asset=" + this.getAsset() + ", balance=" + this.getBalance() + ", limit=" + this.getLimit() + ", flags=" + this.getFlags() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public TrustLineEntry() {
    }

    @Generated
    public TrustLineEntry(AccountID accountID, TrustLineAsset asset, Int64 balance, Int64 limit, Uint32 flags, TrustLineEntryExt ext) {
        this.accountID = accountID;
        this.asset = asset;
        this.balance = balance;
        this.limit = limit;
        this.flags = flags;
        this.ext = ext;
    }

    @Generated
    public static class TrustLineEntryBuilder {
        @Generated
        private AccountID accountID;
        @Generated
        private TrustLineAsset asset;
        @Generated
        private Int64 balance;
        @Generated
        private Int64 limit;
        @Generated
        private Uint32 flags;
        @Generated
        private TrustLineEntryExt ext;

        @Generated
        TrustLineEntryBuilder() {
        }

        @Generated
        public TrustLineEntryBuilder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        @Generated
        public TrustLineEntryBuilder asset(TrustLineAsset asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public TrustLineEntryBuilder balance(Int64 balance) {
            this.balance = balance;
            return this;
        }

        @Generated
        public TrustLineEntryBuilder limit(Int64 limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public TrustLineEntryBuilder flags(Uint32 flags) {
            this.flags = flags;
            return this;
        }

        @Generated
        public TrustLineEntryBuilder ext(TrustLineEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public TrustLineEntry build() {
            return new TrustLineEntry(this.accountID, this.asset, this.balance, this.limit, this.flags, this.ext);
        }

        @Generated
        public String toString() {
            return "TrustLineEntry.TrustLineEntryBuilder(accountID=" + this.accountID + ", asset=" + this.asset + ", balance=" + this.balance + ", limit=" + this.limit + ", flags=" + this.flags + ", ext=" + this.ext + ")";
        }
    }

    public static class TrustLineEntryExt
    implements XdrElement {
        private Integer discriminant;
        private TrustLineEntryV1 v1;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.v1.encode(stream);
                }
            }
        }

        public static TrustLineEntryExt decode(XdrDataInputStream stream) throws IOException {
            TrustLineEntryExt decodedTrustLineEntryExt = new TrustLineEntryExt();
            Integer discriminant = stream.readInt();
            decodedTrustLineEntryExt.setDiscriminant(discriminant);
            switch (decodedTrustLineEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedTrustLineEntryExt.v1 = TrustLineEntryV1.decode(stream);
                }
            }
            return decodedTrustLineEntryExt;
        }

        public static TrustLineEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TrustLineEntryExt.fromXdrByteArray(bytes);
        }

        public static TrustLineEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TrustLineEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static TrustLineEntryExtBuilder builder() {
            return new TrustLineEntryExtBuilder();
        }

        @Generated
        public TrustLineEntryExtBuilder toBuilder() {
            return new TrustLineEntryExtBuilder().discriminant(this.discriminant).v1(this.v1);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public TrustLineEntryV1 getV1() {
            return this.v1;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV1(TrustLineEntryV1 v1) {
            this.v1 = v1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrustLineEntryExt)) {
                return false;
            }
            TrustLineEntryExt other = (TrustLineEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            TrustLineEntryV1 this$v1 = this.getV1();
            TrustLineEntryV1 other$v1 = other.getV1();
            return !(this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TrustLineEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            TrustLineEntryV1 $v1 = this.getV1();
            result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TrustLineEntry.TrustLineEntryExt(discriminant=" + this.getDiscriminant() + ", v1=" + this.getV1() + ")";
        }

        @Generated
        public TrustLineEntryExt() {
        }

        @Generated
        public TrustLineEntryExt(Integer discriminant, TrustLineEntryV1 v1) {
            this.discriminant = discriminant;
            this.v1 = v1;
        }

        @Generated
        public static class TrustLineEntryExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private TrustLineEntryV1 v1;

            @Generated
            TrustLineEntryExtBuilder() {
            }

            @Generated
            public TrustLineEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public TrustLineEntryExtBuilder v1(TrustLineEntryV1 v1) {
                this.v1 = v1;
                return this;
            }

            @Generated
            public TrustLineEntryExt build() {
                return new TrustLineEntryExt(this.discriminant, this.v1);
            }

            @Generated
            public String toString() {
                return "TrustLineEntry.TrustLineEntryExt.TrustLineEntryExtBuilder(discriminant=" + this.discriminant + ", v1=" + this.v1 + ")";
            }
        }

        public static class TrustLineEntryV1
        implements XdrElement {
            private Liabilities liabilities;
            private TrustLineEntryV1Ext ext;

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                this.liabilities.encode(stream);
                this.ext.encode(stream);
            }

            public static TrustLineEntryV1 decode(XdrDataInputStream stream) throws IOException {
                TrustLineEntryV1 decodedTrustLineEntryV1 = new TrustLineEntryV1();
                decodedTrustLineEntryV1.liabilities = Liabilities.decode(stream);
                decodedTrustLineEntryV1.ext = TrustLineEntryV1Ext.decode(stream);
                return decodedTrustLineEntryV1;
            }

            public static TrustLineEntryV1 fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return TrustLineEntryV1.fromXdrByteArray(bytes);
            }

            public static TrustLineEntryV1 fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return TrustLineEntryV1.decode(xdrDataInputStream);
            }

            @Generated
            public static TrustLineEntryV1Builder builder() {
                return new TrustLineEntryV1Builder();
            }

            @Generated
            public TrustLineEntryV1Builder toBuilder() {
                return new TrustLineEntryV1Builder().liabilities(this.liabilities).ext(this.ext);
            }

            @Generated
            public Liabilities getLiabilities() {
                return this.liabilities;
            }

            @Generated
            public TrustLineEntryV1Ext getExt() {
                return this.ext;
            }

            @Generated
            public void setLiabilities(Liabilities liabilities) {
                this.liabilities = liabilities;
            }

            @Generated
            public void setExt(TrustLineEntryV1Ext ext) {
                this.ext = ext;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TrustLineEntryV1)) {
                    return false;
                }
                TrustLineEntryV1 other = (TrustLineEntryV1)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Liabilities this$liabilities = this.getLiabilities();
                Liabilities other$liabilities = other.getLiabilities();
                if (this$liabilities == null ? other$liabilities != null : !((Object)this$liabilities).equals(other$liabilities)) {
                    return false;
                }
                TrustLineEntryV1Ext this$ext = this.getExt();
                TrustLineEntryV1Ext other$ext = other.getExt();
                return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TrustLineEntryV1;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Liabilities $liabilities = this.getLiabilities();
                result = result * 59 + ($liabilities == null ? 43 : ((Object)$liabilities).hashCode());
                TrustLineEntryV1Ext $ext = this.getExt();
                result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "TrustLineEntry.TrustLineEntryExt.TrustLineEntryV1(liabilities=" + this.getLiabilities() + ", ext=" + this.getExt() + ")";
            }

            @Generated
            public TrustLineEntryV1() {
            }

            @Generated
            public TrustLineEntryV1(Liabilities liabilities, TrustLineEntryV1Ext ext) {
                this.liabilities = liabilities;
                this.ext = ext;
            }

            @Generated
            public static class TrustLineEntryV1Builder {
                @Generated
                private Liabilities liabilities;
                @Generated
                private TrustLineEntryV1Ext ext;

                @Generated
                TrustLineEntryV1Builder() {
                }

                @Generated
                public TrustLineEntryV1Builder liabilities(Liabilities liabilities) {
                    this.liabilities = liabilities;
                    return this;
                }

                @Generated
                public TrustLineEntryV1Builder ext(TrustLineEntryV1Ext ext) {
                    this.ext = ext;
                    return this;
                }

                @Generated
                public TrustLineEntryV1 build() {
                    return new TrustLineEntryV1(this.liabilities, this.ext);
                }

                @Generated
                public String toString() {
                    return "TrustLineEntry.TrustLineEntryExt.TrustLineEntryV1.TrustLineEntryV1Builder(liabilities=" + this.liabilities + ", ext=" + this.ext + ")";
                }
            }

            public static class TrustLineEntryV1Ext
            implements XdrElement {
                private Integer discriminant;
                private TrustLineEntryExtensionV2 v2;

                @Override
                public void encode(XdrDataOutputStream stream) throws IOException {
                    stream.writeInt(this.discriminant);
                    switch (this.discriminant) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            this.v2.encode(stream);
                        }
                    }
                }

                public static TrustLineEntryV1Ext decode(XdrDataInputStream stream) throws IOException {
                    TrustLineEntryV1Ext decodedTrustLineEntryV1Ext = new TrustLineEntryV1Ext();
                    Integer discriminant = stream.readInt();
                    decodedTrustLineEntryV1Ext.setDiscriminant(discriminant);
                    switch (decodedTrustLineEntryV1Ext.getDiscriminant()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            decodedTrustLineEntryV1Ext.v2 = TrustLineEntryExtensionV2.decode(stream);
                        }
                    }
                    return decodedTrustLineEntryV1Ext;
                }

                public static TrustLineEntryV1Ext fromXdrBase64(String xdr) throws IOException {
                    byte[] bytes = Base64Factory.getInstance().decode(xdr);
                    return TrustLineEntryV1Ext.fromXdrByteArray(bytes);
                }

                public static TrustLineEntryV1Ext fromXdrByteArray(byte[] xdr) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                    return TrustLineEntryV1Ext.decode(xdrDataInputStream);
                }

                @Generated
                public static TrustLineEntryV1ExtBuilder builder() {
                    return new TrustLineEntryV1ExtBuilder();
                }

                @Generated
                public TrustLineEntryV1ExtBuilder toBuilder() {
                    return new TrustLineEntryV1ExtBuilder().discriminant(this.discriminant).v2(this.v2);
                }

                @Generated
                public Integer getDiscriminant() {
                    return this.discriminant;
                }

                @Generated
                public TrustLineEntryExtensionV2 getV2() {
                    return this.v2;
                }

                @Generated
                public void setDiscriminant(Integer discriminant) {
                    this.discriminant = discriminant;
                }

                @Generated
                public void setV2(TrustLineEntryExtensionV2 v2) {
                    this.v2 = v2;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TrustLineEntryV1Ext)) {
                        return false;
                    }
                    TrustLineEntryV1Ext other = (TrustLineEntryV1Ext)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Integer this$discriminant = this.getDiscriminant();
                    Integer other$discriminant = other.getDiscriminant();
                    if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                        return false;
                    }
                    TrustLineEntryExtensionV2 this$v2 = this.getV2();
                    TrustLineEntryExtensionV2 other$v2 = other.getV2();
                    return !(this$v2 == null ? other$v2 != null : !((Object)this$v2).equals(other$v2));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TrustLineEntryV1Ext;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Integer $discriminant = this.getDiscriminant();
                    result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
                    TrustLineEntryExtensionV2 $v2 = this.getV2();
                    result = result * 59 + ($v2 == null ? 43 : ((Object)$v2).hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "TrustLineEntry.TrustLineEntryExt.TrustLineEntryV1.TrustLineEntryV1Ext(discriminant=" + this.getDiscriminant() + ", v2=" + this.getV2() + ")";
                }

                @Generated
                public TrustLineEntryV1Ext() {
                }

                @Generated
                public TrustLineEntryV1Ext(Integer discriminant, TrustLineEntryExtensionV2 v2) {
                    this.discriminant = discriminant;
                    this.v2 = v2;
                }

                @Generated
                public static class TrustLineEntryV1ExtBuilder {
                    @Generated
                    private Integer discriminant;
                    @Generated
                    private TrustLineEntryExtensionV2 v2;

                    @Generated
                    TrustLineEntryV1ExtBuilder() {
                    }

                    @Generated
                    public TrustLineEntryV1ExtBuilder discriminant(Integer discriminant) {
                        this.discriminant = discriminant;
                        return this;
                    }

                    @Generated
                    public TrustLineEntryV1ExtBuilder v2(TrustLineEntryExtensionV2 v2) {
                        this.v2 = v2;
                        return this;
                    }

                    @Generated
                    public TrustLineEntryV1Ext build() {
                        return new TrustLineEntryV1Ext(this.discriminant, this.v2);
                    }

                    @Generated
                    public String toString() {
                        return "TrustLineEntry.TrustLineEntryExt.TrustLineEntryV1.TrustLineEntryV1Ext.TrustLineEntryV1ExtBuilder(discriminant=" + this.discriminant + ", v2=" + this.v2 + ")";
                    }
                }
            }
        }
    }
}

