/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public final class XdrUnsignedInteger
implements XdrElement {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private final Long number;

    public XdrUnsignedInteger(Long number) {
        if (number < 0L || number > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("number must be between 0 and 2^32 - 1 inclusive");
        }
        this.number = number;
    }

    public XdrUnsignedInteger(Integer number) {
        if (number < 0) {
            throw new IllegalArgumentException("number must be greater than or equal to 0 if you want to construct it from Integer");
        }
        this.number = number.longValue();
    }

    public static XdrUnsignedInteger decode(XdrDataInputStream stream) throws IOException {
        int intValue = stream.readInt();
        long uint32Value = Integer.toUnsignedLong(intValue);
        return new XdrUnsignedInteger(uint32Value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.number.intValue());
    }

    public static XdrUnsignedInteger fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return XdrUnsignedInteger.fromXdrByteArray(bytes);
    }

    public static XdrUnsignedInteger fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return XdrUnsignedInteger.decode(xdrDataInputStream);
    }

    @Generated
    public Long getNumber() {
        return this.number;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XdrUnsignedInteger)) {
            return false;
        }
        XdrUnsignedInteger other = (XdrUnsignedInteger)o;
        Long this$number = this.getNumber();
        Long other$number = other.getNumber();
        return !(this$number == null ? other$number != null : !((Object)this$number).equals(other$number));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "XdrUnsignedInteger(number=" + this.getNumber() + ")";
    }
}

