// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * AllowTrustResult's original definition in the XDR file is:
 *
 * <pre>
 * union AllowTrustResult switch (AllowTrustResultCode code)
 * {
 * case ALLOW_TRUST_SUCCESS:
 *     void;
 * case ALLOW_TRUST_MALFORMED:
 * case ALLOW_TRUST_NO_TRUST_LINE:
 * case ALLOW_TRUST_TRUST_NOT_REQUIRED:
 * case ALLOW_TRUST_CANT_REVOKE:
 * case ALLOW_TRUST_SELF_NOT_ALLOWED:
 * case ALLOW_TRUST_LOW_RESERVE:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class AllowTrustResult implements XdrElement {
  private AllowTrustResultCode discriminant;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ALLOW_TRUST_SUCCESS:
        break;
      case ALLOW_TRUST_MALFORMED:
      case ALLOW_TRUST_NO_TRUST_LINE:
      case ALLOW_TRUST_TRUST_NOT_REQUIRED:
      case ALLOW_TRUST_CANT_REVOKE:
      case ALLOW_TRUST_SELF_NOT_ALLOWED:
      case ALLOW_TRUST_LOW_RESERVE:
        break;
    }
  }

  public static AllowTrustResult decode(XdrDataInputStream stream) throws IOException {
    AllowTrustResult decodedAllowTrustResult = new AllowTrustResult();
    AllowTrustResultCode discriminant = AllowTrustResultCode.decode(stream);
    decodedAllowTrustResult.setDiscriminant(discriminant);
    switch (decodedAllowTrustResult.getDiscriminant()) {
      case ALLOW_TRUST_SUCCESS:
        break;
      case ALLOW_TRUST_MALFORMED:
      case ALLOW_TRUST_NO_TRUST_LINE:
      case ALLOW_TRUST_TRUST_NOT_REQUIRED:
      case ALLOW_TRUST_CANT_REVOKE:
      case ALLOW_TRUST_SELF_NOT_ALLOWED:
      case ALLOW_TRUST_LOW_RESERVE:
        break;
    }
    return decodedAllowTrustResult;
  }

  public static AllowTrustResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AllowTrustResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
