// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ContractEvent's original definition in the XDR file is:
 *
 * <pre>
 * struct ContractEvent
 * {
 *     // We can use this to add more fields, or because it
 *     // is first, to change ContractEvent into a union.
 *     ExtensionPoint ext;
 *
 *     ContractID&#42; contractID;
 *     ContractEventType type;
 *
 *     union switch (int v)
 *     {
 *     case 0:
 *         struct
 *         {
 *             SCVal topics&lt;&gt;;
 *             SCVal data;
 *         } v0;
 *     }
 *     body;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ContractEvent implements XdrElement {
  private ExtensionPoint ext;
  private ContractID contractID;
  private ContractEventType type;
  private ContractEventBody body;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    if (contractID != null) {
      stream.writeInt(1);
      contractID.encode(stream);
    } else {
      stream.writeInt(0);
    }
    type.encode(stream);
    body.encode(stream);
  }

  public static ContractEvent decode(XdrDataInputStream stream) throws IOException {
    ContractEvent decodedContractEvent = new ContractEvent();
    decodedContractEvent.ext = ExtensionPoint.decode(stream);
    int contractIDPresent = stream.readInt();
    if (contractIDPresent != 0) {
      decodedContractEvent.contractID = ContractID.decode(stream);
    }
    decodedContractEvent.type = ContractEventType.decode(stream);
    decodedContractEvent.body = ContractEventBody.decode(stream);
    return decodedContractEvent;
  }

  public static ContractEvent fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ContractEvent fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * ContractEventBody's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         struct
   *         {
   *             SCVal topics&lt;&gt;;
   *             SCVal data;
   *         } v0;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class ContractEventBody implements XdrElement {
    private Integer discriminant;
    private ContractEventV0 v0;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          v0.encode(stream);
          break;
      }
    }

    public static ContractEventBody decode(XdrDataInputStream stream) throws IOException {
      ContractEventBody decodedContractEventBody = new ContractEventBody();
      Integer discriminant = stream.readInt();
      decodedContractEventBody.setDiscriminant(discriminant);
      switch (decodedContractEventBody.getDiscriminant()) {
        case 0:
          decodedContractEventBody.v0 = ContractEventV0.decode(stream);
          break;
      }
      return decodedContractEventBody;
    }

    public static ContractEventBody fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static ContractEventBody fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    /**
     * ContractEventV0's original definition in the XDR file is:
     *
     * <pre>
     * struct
     *         {
     *             SCVal topics&lt;&gt;;
     *             SCVal data;
     *         }
     * </pre>
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class ContractEventV0 implements XdrElement {
      private SCVal[] topics;
      private SCVal data;

      public void encode(XdrDataOutputStream stream) throws IOException {
        int topicsSize = getTopics().length;
        stream.writeInt(topicsSize);
        for (int i = 0; i < topicsSize; i++) {
          topics[i].encode(stream);
        }
        data.encode(stream);
      }

      public static ContractEventV0 decode(XdrDataInputStream stream) throws IOException {
        ContractEventV0 decodedContractEventV0 = new ContractEventV0();
        int topicsSize = stream.readInt();
        decodedContractEventV0.topics = new SCVal[topicsSize];
        for (int i = 0; i < topicsSize; i++) {
          decodedContractEventV0.topics[i] = SCVal.decode(stream);
        }
        decodedContractEventV0.data = SCVal.decode(stream);
        return decodedContractEventV0;
      }

      public static ContractEventV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return fromXdrByteArray(bytes);
      }

      public static ContractEventV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return decode(xdrDataInputStream);
      }
    }
  }
}
