// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * DecoratedSignature's original definition in the XDR file is:
 *
 * <pre>
 * struct DecoratedSignature
 * {
 *     SignatureHint hint;  // last 4 bytes of the public key, used as a hint
 *     Signature signature; // actual signature
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class DecoratedSignature implements XdrElement {
  private SignatureHint hint;
  private Signature signature;

  public void encode(XdrDataOutputStream stream) throws IOException {
    hint.encode(stream);
    signature.encode(stream);
  }

  public static DecoratedSignature decode(XdrDataInputStream stream) throws IOException {
    DecoratedSignature decodedDecoratedSignature = new DecoratedSignature();
    decodedDecoratedSignature.hint = SignatureHint.decode(stream);
    decodedDecoratedSignature.signature = Signature.decode(stream);
    return decodedDecoratedSignature;
  }

  public static DecoratedSignature fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static DecoratedSignature fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
