// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * HotArchiveBucketEntry's original definition in the XDR file is:
 *
 * <pre>
 * union HotArchiveBucketEntry switch (HotArchiveBucketEntryType type)
 * {
 * case HOT_ARCHIVE_ARCHIVED:
 *     LedgerEntry archivedEntry;
 *
 * case HOT_ARCHIVE_LIVE:
 *     LedgerKey key;
 * case HOT_ARCHIVE_METAENTRY:
 *     BucketMetadata metaEntry;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class HotArchiveBucketEntry implements XdrElement {
  private HotArchiveBucketEntryType discriminant;
  private LedgerEntry archivedEntry;
  private LedgerKey key;
  private BucketMetadata metaEntry;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case HOT_ARCHIVE_ARCHIVED:
        archivedEntry.encode(stream);
        break;
      case HOT_ARCHIVE_LIVE:
        key.encode(stream);
        break;
      case HOT_ARCHIVE_METAENTRY:
        metaEntry.encode(stream);
        break;
    }
  }

  public static HotArchiveBucketEntry decode(XdrDataInputStream stream) throws IOException {
    HotArchiveBucketEntry decodedHotArchiveBucketEntry = new HotArchiveBucketEntry();
    HotArchiveBucketEntryType discriminant = HotArchiveBucketEntryType.decode(stream);
    decodedHotArchiveBucketEntry.setDiscriminant(discriminant);
    switch (decodedHotArchiveBucketEntry.getDiscriminant()) {
      case HOT_ARCHIVE_ARCHIVED:
        decodedHotArchiveBucketEntry.archivedEntry = LedgerEntry.decode(stream);
        break;
      case HOT_ARCHIVE_LIVE:
        decodedHotArchiveBucketEntry.key = LedgerKey.decode(stream);
        break;
      case HOT_ARCHIVE_METAENTRY:
        decodedHotArchiveBucketEntry.metaEntry = BucketMetadata.decode(stream);
        break;
    }
    return decodedHotArchiveBucketEntry;
  }

  public static HotArchiveBucketEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static HotArchiveBucketEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
