// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * InnerTransactionResult's original definition in the XDR file is:
 *
 * <pre>
 * struct InnerTransactionResult
 * {
 *     // Always 0. Here for binary compatibility.
 *     int64 feeCharged;
 *
 *     union switch (TransactionResultCode code)
 *     {
 *     // txFEE_BUMP_INNER_SUCCESS is not included
 *     case txSUCCESS:
 *     case txFAILED:
 *         OperationResult results&lt;&gt;;
 *     case txTOO_EARLY:
 *     case txTOO_LATE:
 *     case txMISSING_OPERATION:
 *     case txBAD_SEQ:
 *     case txBAD_AUTH:
 *     case txINSUFFICIENT_BALANCE:
 *     case txNO_ACCOUNT:
 *     case txINSUFFICIENT_FEE:
 *     case txBAD_AUTH_EXTRA:
 *     case txINTERNAL_ERROR:
 *     case txNOT_SUPPORTED:
 *     // txFEE_BUMP_INNER_FAILED is not included
 *     case txBAD_SPONSORSHIP:
 *     case txBAD_MIN_SEQ_AGE_OR_GAP:
 *     case txMALFORMED:
 *     case txSOROBAN_INVALID:
 *         void;
 *     }
 *     result;
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class InnerTransactionResult implements XdrElement {
  private Int64 feeCharged;
  private InnerTransactionResultResult result;
  private InnerTransactionResultExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    feeCharged.encode(stream);
    result.encode(stream);
    ext.encode(stream);
  }

  public static InnerTransactionResult decode(XdrDataInputStream stream) throws IOException {
    InnerTransactionResult decodedInnerTransactionResult = new InnerTransactionResult();
    decodedInnerTransactionResult.feeCharged = Int64.decode(stream);
    decodedInnerTransactionResult.result = InnerTransactionResultResult.decode(stream);
    decodedInnerTransactionResult.ext = InnerTransactionResultExt.decode(stream);
    return decodedInnerTransactionResult;
  }

  public static InnerTransactionResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static InnerTransactionResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * InnerTransactionResultResult's original definition in the XDR file is:
   *
   * <pre>
   * union switch (TransactionResultCode code)
   *     {
   *     // txFEE_BUMP_INNER_SUCCESS is not included
   *     case txSUCCESS:
   *     case txFAILED:
   *         OperationResult results&lt;&gt;;
   *     case txTOO_EARLY:
   *     case txTOO_LATE:
   *     case txMISSING_OPERATION:
   *     case txBAD_SEQ:
   *     case txBAD_AUTH:
   *     case txINSUFFICIENT_BALANCE:
   *     case txNO_ACCOUNT:
   *     case txINSUFFICIENT_FEE:
   *     case txBAD_AUTH_EXTRA:
   *     case txINTERNAL_ERROR:
   *     case txNOT_SUPPORTED:
   *     // txFEE_BUMP_INNER_FAILED is not included
   *     case txBAD_SPONSORSHIP:
   *     case txBAD_MIN_SEQ_AGE_OR_GAP:
   *     case txMALFORMED:
   *     case txSOROBAN_INVALID:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class InnerTransactionResultResult implements XdrElement {
    private TransactionResultCode discriminant;
    private OperationResult[] results;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case txSUCCESS:
        case txFAILED:
          int resultsSize = getResults().length;
          stream.writeInt(resultsSize);
          for (int i = 0; i < resultsSize; i++) {
            results[i].encode(stream);
          }
          break;
        case txTOO_EARLY:
        case txTOO_LATE:
        case txMISSING_OPERATION:
        case txBAD_SEQ:
        case txBAD_AUTH:
        case txINSUFFICIENT_BALANCE:
        case txNO_ACCOUNT:
        case txINSUFFICIENT_FEE:
        case txBAD_AUTH_EXTRA:
        case txINTERNAL_ERROR:
        case txNOT_SUPPORTED:
        case txBAD_SPONSORSHIP:
        case txBAD_MIN_SEQ_AGE_OR_GAP:
        case txMALFORMED:
        case txSOROBAN_INVALID:
          break;
      }
    }

    public static InnerTransactionResultResult decode(XdrDataInputStream stream)
        throws IOException {
      InnerTransactionResultResult decodedInnerTransactionResultResult =
          new InnerTransactionResultResult();
      TransactionResultCode discriminant = TransactionResultCode.decode(stream);
      decodedInnerTransactionResultResult.setDiscriminant(discriminant);
      switch (decodedInnerTransactionResultResult.getDiscriminant()) {
        case txSUCCESS:
        case txFAILED:
          int resultsSize = stream.readInt();
          decodedInnerTransactionResultResult.results = new OperationResult[resultsSize];
          for (int i = 0; i < resultsSize; i++) {
            decodedInnerTransactionResultResult.results[i] = OperationResult.decode(stream);
          }
          break;
        case txTOO_EARLY:
        case txTOO_LATE:
        case txMISSING_OPERATION:
        case txBAD_SEQ:
        case txBAD_AUTH:
        case txINSUFFICIENT_BALANCE:
        case txNO_ACCOUNT:
        case txINSUFFICIENT_FEE:
        case txBAD_AUTH_EXTRA:
        case txINTERNAL_ERROR:
        case txNOT_SUPPORTED:
        case txBAD_SPONSORSHIP:
        case txBAD_MIN_SEQ_AGE_OR_GAP:
        case txMALFORMED:
        case txSOROBAN_INVALID:
          break;
      }
      return decodedInnerTransactionResultResult;
    }

    public static InnerTransactionResultResult fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static InnerTransactionResultResult fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * InnerTransactionResultExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class InnerTransactionResultExt implements XdrElement {
    private Integer discriminant;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
      }
    }

    public static InnerTransactionResultExt decode(XdrDataInputStream stream) throws IOException {
      InnerTransactionResultExt decodedInnerTransactionResultExt = new InnerTransactionResultExt();
      Integer discriminant = stream.readInt();
      decodedInnerTransactionResultExt.setDiscriminant(discriminant);
      switch (decodedInnerTransactionResultExt.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedInnerTransactionResultExt;
    }

    public static InnerTransactionResultExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static InnerTransactionResultExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
