// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * InvokeContractArgs's original definition in the XDR file is:
 *
 * <pre>
 * struct InvokeContractArgs {
 *     SCAddress contractAddress;
 *     SCSymbol functionName;
 *     SCVal args&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class InvokeContractArgs implements XdrElement {
  private SCAddress contractAddress;
  private SCSymbol functionName;
  private SCVal[] args;

  public void encode(XdrDataOutputStream stream) throws IOException {
    contractAddress.encode(stream);
    functionName.encode(stream);
    int argsSize = getArgs().length;
    stream.writeInt(argsSize);
    for (int i = 0; i < argsSize; i++) {
      args[i].encode(stream);
    }
  }

  public static InvokeContractArgs decode(XdrDataInputStream stream) throws IOException {
    InvokeContractArgs decodedInvokeContractArgs = new InvokeContractArgs();
    decodedInvokeContractArgs.contractAddress = SCAddress.decode(stream);
    decodedInvokeContractArgs.functionName = SCSymbol.decode(stream);
    int argsSize = stream.readInt();
    decodedInvokeContractArgs.args = new SCVal[argsSize];
    for (int i = 0; i < argsSize; i++) {
      decodedInvokeContractArgs.args[i] = SCVal.decode(stream);
    }
    return decodedInvokeContractArgs;
  }

  public static InvokeContractArgs fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static InvokeContractArgs fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
