// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerCloseMetaBatch's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerCloseMetaBatch
 * {
 *     // starting ledger sequence number in the batch
 *     uint32 startSequence;
 *
 *     // ending ledger sequence number in the batch
 *     uint32 endSequence;
 *
 *     // Ledger close meta for each ledger within the batch
 *     LedgerCloseMeta ledgerCloseMetas&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerCloseMetaBatch implements XdrElement {
  private Uint32 startSequence;
  private Uint32 endSequence;
  private LedgerCloseMeta[] ledgerCloseMetas;

  public void encode(XdrDataOutputStream stream) throws IOException {
    startSequence.encode(stream);
    endSequence.encode(stream);
    int ledgerCloseMetasSize = getLedgerCloseMetas().length;
    stream.writeInt(ledgerCloseMetasSize);
    for (int i = 0; i < ledgerCloseMetasSize; i++) {
      ledgerCloseMetas[i].encode(stream);
    }
  }

  public static LedgerCloseMetaBatch decode(XdrDataInputStream stream) throws IOException {
    LedgerCloseMetaBatch decodedLedgerCloseMetaBatch = new LedgerCloseMetaBatch();
    decodedLedgerCloseMetaBatch.startSequence = Uint32.decode(stream);
    decodedLedgerCloseMetaBatch.endSequence = Uint32.decode(stream);
    int ledgerCloseMetasSize = stream.readInt();
    decodedLedgerCloseMetaBatch.ledgerCloseMetas = new LedgerCloseMeta[ledgerCloseMetasSize];
    for (int i = 0; i < ledgerCloseMetasSize; i++) {
      decodedLedgerCloseMetaBatch.ledgerCloseMetas[i] = LedgerCloseMeta.decode(stream);
    }
    return decodedLedgerCloseMetaBatch;
  }

  public static LedgerCloseMetaBatch fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerCloseMetaBatch fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
