// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerCloseMetaV1's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerCloseMetaV1
 * {
 *     LedgerCloseMetaExt ext;
 *
 *     LedgerHeaderHistoryEntry ledgerHeader;
 *
 *     GeneralizedTransactionSet txSet;
 *
 *     // NB: transactions are sorted in apply order here
 *     // fees for all transactions are processed first
 *     // followed by applying transactions
 *     TransactionResultMeta txProcessing&lt;&gt;;
 *
 *     // upgrades are applied last
 *     UpgradeEntryMeta upgradesProcessing&lt;&gt;;
 *
 *     // other misc information attached to the ledger close
 *     SCPHistoryEntry scpInfo&lt;&gt;;
 *
 *     // Size in bytes of live Soroban state, to support downstream
 *     // systems calculating storage fees correctly.
 *     uint64 totalByteSizeOfLiveSorobanState;
 *
 *     // TTL and data/code keys that have been evicted at this ledger.
 *     LedgerKey evictedKeys&lt;&gt;;
 *
 *     // Maintained for backwards compatibility, should never be populated.
 *     LedgerEntry unused&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerCloseMetaV1 implements XdrElement {
  private LedgerCloseMetaExt ext;
  private LedgerHeaderHistoryEntry ledgerHeader;
  private GeneralizedTransactionSet txSet;
  private TransactionResultMeta[] txProcessing;
  private UpgradeEntryMeta[] upgradesProcessing;
  private SCPHistoryEntry[] scpInfo;
  private Uint64 totalByteSizeOfLiveSorobanState;
  private LedgerKey[] evictedKeys;
  private LedgerEntry[] unused;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    ledgerHeader.encode(stream);
    txSet.encode(stream);
    int txProcessingSize = getTxProcessing().length;
    stream.writeInt(txProcessingSize);
    for (int i = 0; i < txProcessingSize; i++) {
      txProcessing[i].encode(stream);
    }
    int upgradesProcessingSize = getUpgradesProcessing().length;
    stream.writeInt(upgradesProcessingSize);
    for (int i = 0; i < upgradesProcessingSize; i++) {
      upgradesProcessing[i].encode(stream);
    }
    int scpInfoSize = getScpInfo().length;
    stream.writeInt(scpInfoSize);
    for (int i = 0; i < scpInfoSize; i++) {
      scpInfo[i].encode(stream);
    }
    totalByteSizeOfLiveSorobanState.encode(stream);
    int evictedKeysSize = getEvictedKeys().length;
    stream.writeInt(evictedKeysSize);
    for (int i = 0; i < evictedKeysSize; i++) {
      evictedKeys[i].encode(stream);
    }
    int unusedSize = getUnused().length;
    stream.writeInt(unusedSize);
    for (int i = 0; i < unusedSize; i++) {
      unused[i].encode(stream);
    }
  }

  public static LedgerCloseMetaV1 decode(XdrDataInputStream stream) throws IOException {
    LedgerCloseMetaV1 decodedLedgerCloseMetaV1 = new LedgerCloseMetaV1();
    decodedLedgerCloseMetaV1.ext = LedgerCloseMetaExt.decode(stream);
    decodedLedgerCloseMetaV1.ledgerHeader = LedgerHeaderHistoryEntry.decode(stream);
    decodedLedgerCloseMetaV1.txSet = GeneralizedTransactionSet.decode(stream);
    int txProcessingSize = stream.readInt();
    decodedLedgerCloseMetaV1.txProcessing = new TransactionResultMeta[txProcessingSize];
    for (int i = 0; i < txProcessingSize; i++) {
      decodedLedgerCloseMetaV1.txProcessing[i] = TransactionResultMeta.decode(stream);
    }
    int upgradesProcessingSize = stream.readInt();
    decodedLedgerCloseMetaV1.upgradesProcessing = new UpgradeEntryMeta[upgradesProcessingSize];
    for (int i = 0; i < upgradesProcessingSize; i++) {
      decodedLedgerCloseMetaV1.upgradesProcessing[i] = UpgradeEntryMeta.decode(stream);
    }
    int scpInfoSize = stream.readInt();
    decodedLedgerCloseMetaV1.scpInfo = new SCPHistoryEntry[scpInfoSize];
    for (int i = 0; i < scpInfoSize; i++) {
      decodedLedgerCloseMetaV1.scpInfo[i] = SCPHistoryEntry.decode(stream);
    }
    decodedLedgerCloseMetaV1.totalByteSizeOfLiveSorobanState = Uint64.decode(stream);
    int evictedKeysSize = stream.readInt();
    decodedLedgerCloseMetaV1.evictedKeys = new LedgerKey[evictedKeysSize];
    for (int i = 0; i < evictedKeysSize; i++) {
      decodedLedgerCloseMetaV1.evictedKeys[i] = LedgerKey.decode(stream);
    }
    int unusedSize = stream.readInt();
    decodedLedgerCloseMetaV1.unused = new LedgerEntry[unusedSize];
    for (int i = 0; i < unusedSize; i++) {
      decodedLedgerCloseMetaV1.unused[i] = LedgerEntry.decode(stream);
    }
    return decodedLedgerCloseMetaV1;
  }

  public static LedgerCloseMetaV1 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerCloseMetaV1 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
