// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerEntry
 * {
 *     uint32 lastModifiedLedgerSeq; // ledger the LedgerEntry was last changed
 *
 *     union switch (LedgerEntryType type)
 *     {
 *     case ACCOUNT:
 *         AccountEntry account;
 *     case TRUSTLINE:
 *         TrustLineEntry trustLine;
 *     case OFFER:
 *         OfferEntry offer;
 *     case DATA:
 *         DataEntry data;
 *     case CLAIMABLE_BALANCE:
 *         ClaimableBalanceEntry claimableBalance;
 *     case LIQUIDITY_POOL:
 *         LiquidityPoolEntry liquidityPool;
 *     case CONTRACT_DATA:
 *         ContractDataEntry contractData;
 *     case CONTRACT_CODE:
 *         ContractCodeEntry contractCode;
 *     case CONFIG_SETTING:
 *         ConfigSettingEntry configSetting;
 *     case TTL:
 *         TTLEntry ttl;
 *     }
 *     data;
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     case 1:
 *         LedgerEntryExtensionV1 v1;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerEntry implements XdrElement {
  private Uint32 lastModifiedLedgerSeq;
  private LedgerEntryData data;
  private LedgerEntryExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    lastModifiedLedgerSeq.encode(stream);
    data.encode(stream);
    ext.encode(stream);
  }

  public static LedgerEntry decode(XdrDataInputStream stream) throws IOException {
    LedgerEntry decodedLedgerEntry = new LedgerEntry();
    decodedLedgerEntry.lastModifiedLedgerSeq = Uint32.decode(stream);
    decodedLedgerEntry.data = LedgerEntryData.decode(stream);
    decodedLedgerEntry.ext = LedgerEntryExt.decode(stream);
    return decodedLedgerEntry;
  }

  public static LedgerEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * LedgerEntryData's original definition in the XDR file is:
   *
   * <pre>
   * union switch (LedgerEntryType type)
   *     {
   *     case ACCOUNT:
   *         AccountEntry account;
   *     case TRUSTLINE:
   *         TrustLineEntry trustLine;
   *     case OFFER:
   *         OfferEntry offer;
   *     case DATA:
   *         DataEntry data;
   *     case CLAIMABLE_BALANCE:
   *         ClaimableBalanceEntry claimableBalance;
   *     case LIQUIDITY_POOL:
   *         LiquidityPoolEntry liquidityPool;
   *     case CONTRACT_DATA:
   *         ContractDataEntry contractData;
   *     case CONTRACT_CODE:
   *         ContractCodeEntry contractCode;
   *     case CONFIG_SETTING:
   *         ConfigSettingEntry configSetting;
   *     case TTL:
   *         TTLEntry ttl;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerEntryData implements XdrElement {
    private LedgerEntryType discriminant;
    private AccountEntry account;
    private TrustLineEntry trustLine;
    private OfferEntry offer;
    private DataEntry data;
    private ClaimableBalanceEntry claimableBalance;
    private LiquidityPoolEntry liquidityPool;
    private ContractDataEntry contractData;
    private ContractCodeEntry contractCode;
    private ConfigSettingEntry configSetting;
    private TTLEntry ttl;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case ACCOUNT:
          account.encode(stream);
          break;
        case TRUSTLINE:
          trustLine.encode(stream);
          break;
        case OFFER:
          offer.encode(stream);
          break;
        case DATA:
          data.encode(stream);
          break;
        case CLAIMABLE_BALANCE:
          claimableBalance.encode(stream);
          break;
        case LIQUIDITY_POOL:
          liquidityPool.encode(stream);
          break;
        case CONTRACT_DATA:
          contractData.encode(stream);
          break;
        case CONTRACT_CODE:
          contractCode.encode(stream);
          break;
        case CONFIG_SETTING:
          configSetting.encode(stream);
          break;
        case TTL:
          ttl.encode(stream);
          break;
      }
    }

    public static LedgerEntryData decode(XdrDataInputStream stream) throws IOException {
      LedgerEntryData decodedLedgerEntryData = new LedgerEntryData();
      LedgerEntryType discriminant = LedgerEntryType.decode(stream);
      decodedLedgerEntryData.setDiscriminant(discriminant);
      switch (decodedLedgerEntryData.getDiscriminant()) {
        case ACCOUNT:
          decodedLedgerEntryData.account = AccountEntry.decode(stream);
          break;
        case TRUSTLINE:
          decodedLedgerEntryData.trustLine = TrustLineEntry.decode(stream);
          break;
        case OFFER:
          decodedLedgerEntryData.offer = OfferEntry.decode(stream);
          break;
        case DATA:
          decodedLedgerEntryData.data = DataEntry.decode(stream);
          break;
        case CLAIMABLE_BALANCE:
          decodedLedgerEntryData.claimableBalance = ClaimableBalanceEntry.decode(stream);
          break;
        case LIQUIDITY_POOL:
          decodedLedgerEntryData.liquidityPool = LiquidityPoolEntry.decode(stream);
          break;
        case CONTRACT_DATA:
          decodedLedgerEntryData.contractData = ContractDataEntry.decode(stream);
          break;
        case CONTRACT_CODE:
          decodedLedgerEntryData.contractCode = ContractCodeEntry.decode(stream);
          break;
        case CONFIG_SETTING:
          decodedLedgerEntryData.configSetting = ConfigSettingEntry.decode(stream);
          break;
        case TTL:
          decodedLedgerEntryData.ttl = TTLEntry.decode(stream);
          break;
      }
      return decodedLedgerEntryData;
    }

    public static LedgerEntryData fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerEntryData fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * LedgerEntryExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     case 1:
   *         LedgerEntryExtensionV1 v1;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerEntryExt implements XdrElement {
    private Integer discriminant;
    private LedgerEntryExtensionV1 v1;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 1:
          v1.encode(stream);
          break;
      }
    }

    public static LedgerEntryExt decode(XdrDataInputStream stream) throws IOException {
      LedgerEntryExt decodedLedgerEntryExt = new LedgerEntryExt();
      Integer discriminant = stream.readInt();
      decodedLedgerEntryExt.setDiscriminant(discriminant);
      switch (decodedLedgerEntryExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedLedgerEntryExt.v1 = LedgerEntryExtensionV1.decode(stream);
          break;
      }
      return decodedLedgerEntryExt;
    }

    public static LedgerEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
