// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerEntryChangeType's original definition in the XDR file is:
 *
 * <pre>
 * enum LedgerEntryChangeType
 * {
 *     LEDGER_ENTRY_CREATED = 0, // entry was added to the ledger
 *     LEDGER_ENTRY_UPDATED = 1, // entry was modified in the ledger
 *     LEDGER_ENTRY_REMOVED = 2, // entry was removed from the ledger
 *     LEDGER_ENTRY_STATE    = 3, // value of the entry
 *     LEDGER_ENTRY_RESTORED = 4  // archived entry was restored in the ledger
 * };
 * </pre>
 */
public enum LedgerEntryChangeType implements XdrElement {
  LEDGER_ENTRY_CREATED(0),
  LEDGER_ENTRY_UPDATED(1),
  LEDGER_ENTRY_REMOVED(2),
  LEDGER_ENTRY_STATE(3),
  LEDGER_ENTRY_RESTORED(4);

  private final int value;

  LedgerEntryChangeType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static LedgerEntryChangeType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return LEDGER_ENTRY_CREATED;
      case 1:
        return LEDGER_ENTRY_UPDATED;
      case 2:
        return LEDGER_ENTRY_REMOVED;
      case 3:
        return LEDGER_ENTRY_STATE;
      case 4:
        return LEDGER_ENTRY_RESTORED;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static LedgerEntryChangeType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerEntryChangeType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
