// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerUpgrade's original definition in the XDR file is:
 *
 * <pre>
 * union LedgerUpgrade switch (LedgerUpgradeType type)
 * {
 * case LEDGER_UPGRADE_VERSION:
 *     uint32 newLedgerVersion; // update ledgerVersion
 * case LEDGER_UPGRADE_BASE_FEE:
 *     uint32 newBaseFee; // update baseFee
 * case LEDGER_UPGRADE_MAX_TX_SET_SIZE:
 *     uint32 newMaxTxSetSize; // update maxTxSetSize
 * case LEDGER_UPGRADE_BASE_RESERVE:
 *     uint32 newBaseReserve; // update baseReserve
 * case LEDGER_UPGRADE_FLAGS:
 *     uint32 newFlags; // update flags
 * case LEDGER_UPGRADE_CONFIG:
 *     // Update arbitrary `ConfigSetting` entries identified by the key.
 *     ConfigUpgradeSetKey newConfig;
 * case LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE:
 *     // Update ConfigSettingContractExecutionLanesV0.ledgerMaxTxCount without
 *     // using `LEDGER_UPGRADE_CONFIG`.
 *     uint32 newMaxSorobanTxSetSize;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerUpgrade implements XdrElement {
  private LedgerUpgradeType discriminant;
  private Uint32 newLedgerVersion;
  private Uint32 newBaseFee;
  private Uint32 newMaxTxSetSize;
  private Uint32 newBaseReserve;
  private Uint32 newFlags;
  private ConfigUpgradeSetKey newConfig;
  private Uint32 newMaxSorobanTxSetSize;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case LEDGER_UPGRADE_VERSION:
        newLedgerVersion.encode(stream);
        break;
      case LEDGER_UPGRADE_BASE_FEE:
        newBaseFee.encode(stream);
        break;
      case LEDGER_UPGRADE_MAX_TX_SET_SIZE:
        newMaxTxSetSize.encode(stream);
        break;
      case LEDGER_UPGRADE_BASE_RESERVE:
        newBaseReserve.encode(stream);
        break;
      case LEDGER_UPGRADE_FLAGS:
        newFlags.encode(stream);
        break;
      case LEDGER_UPGRADE_CONFIG:
        newConfig.encode(stream);
        break;
      case LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE:
        newMaxSorobanTxSetSize.encode(stream);
        break;
    }
  }

  public static LedgerUpgrade decode(XdrDataInputStream stream) throws IOException {
    LedgerUpgrade decodedLedgerUpgrade = new LedgerUpgrade();
    LedgerUpgradeType discriminant = LedgerUpgradeType.decode(stream);
    decodedLedgerUpgrade.setDiscriminant(discriminant);
    switch (decodedLedgerUpgrade.getDiscriminant()) {
      case LEDGER_UPGRADE_VERSION:
        decodedLedgerUpgrade.newLedgerVersion = Uint32.decode(stream);
        break;
      case LEDGER_UPGRADE_BASE_FEE:
        decodedLedgerUpgrade.newBaseFee = Uint32.decode(stream);
        break;
      case LEDGER_UPGRADE_MAX_TX_SET_SIZE:
        decodedLedgerUpgrade.newMaxTxSetSize = Uint32.decode(stream);
        break;
      case LEDGER_UPGRADE_BASE_RESERVE:
        decodedLedgerUpgrade.newBaseReserve = Uint32.decode(stream);
        break;
      case LEDGER_UPGRADE_FLAGS:
        decodedLedgerUpgrade.newFlags = Uint32.decode(stream);
        break;
      case LEDGER_UPGRADE_CONFIG:
        decodedLedgerUpgrade.newConfig = ConfigUpgradeSetKey.decode(stream);
        break;
      case LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE:
        decodedLedgerUpgrade.newMaxSorobanTxSetSize = Uint32.decode(stream);
        break;
    }
    return decodedLedgerUpgrade;
  }

  public static LedgerUpgrade fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerUpgrade fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
