// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * MemoType's original definition in the XDR file is:
 *
 * <pre>
 * enum MemoType
 * {
 *     MEMO_NONE = 0,
 *     MEMO_TEXT = 1,
 *     MEMO_ID = 2,
 *     MEMO_HASH = 3,
 *     MEMO_RETURN = 4
 * };
 * </pre>
 */
public enum MemoType implements XdrElement {
  MEMO_NONE(0),
  MEMO_TEXT(1),
  MEMO_ID(2),
  MEMO_HASH(3),
  MEMO_RETURN(4);

  private final int value;

  MemoType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static MemoType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return MEMO_NONE;
      case 1:
        return MEMO_TEXT;
      case 2:
        return MEMO_ID;
      case 3:
        return MEMO_HASH;
      case 4:
        return MEMO_RETURN;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static MemoType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static MemoType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
