// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PathPaymentStrictReceiveOp's original definition in the XDR file is:
 *
 * <pre>
 * struct PathPaymentStrictReceiveOp
 * {
 *     Asset sendAsset; // asset we pay with
 *     int64 sendMax;   // the maximum amount of sendAsset to
 *                      // send (excluding fees).
 *                      // The operation will fail if can't be met
 *
 *     MuxedAccount destination; // recipient of the payment
 *     Asset destAsset;          // what they end up with
 *     int64 destAmount;         // amount they end up with
 *
 *     Asset path&lt;5&gt;; // additional hops it must go through to get there
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PathPaymentStrictReceiveOp implements XdrElement {
  private Asset sendAsset;
  private Int64 sendMax;
  private MuxedAccount destination;
  private Asset destAsset;
  private Int64 destAmount;
  private Asset[] path;

  public void encode(XdrDataOutputStream stream) throws IOException {
    sendAsset.encode(stream);
    sendMax.encode(stream);
    destination.encode(stream);
    destAsset.encode(stream);
    destAmount.encode(stream);
    int pathSize = getPath().length;
    stream.writeInt(pathSize);
    for (int i = 0; i < pathSize; i++) {
      path[i].encode(stream);
    }
  }

  public static PathPaymentStrictReceiveOp decode(XdrDataInputStream stream) throws IOException {
    PathPaymentStrictReceiveOp decodedPathPaymentStrictReceiveOp = new PathPaymentStrictReceiveOp();
    decodedPathPaymentStrictReceiveOp.sendAsset = Asset.decode(stream);
    decodedPathPaymentStrictReceiveOp.sendMax = Int64.decode(stream);
    decodedPathPaymentStrictReceiveOp.destination = MuxedAccount.decode(stream);
    decodedPathPaymentStrictReceiveOp.destAsset = Asset.decode(stream);
    decodedPathPaymentStrictReceiveOp.destAmount = Int64.decode(stream);
    int pathSize = stream.readInt();
    decodedPathPaymentStrictReceiveOp.path = new Asset[pathSize];
    for (int i = 0; i < pathSize; i++) {
      decodedPathPaymentStrictReceiveOp.path[i] = Asset.decode(stream);
    }
    return decodedPathPaymentStrictReceiveOp;
  }

  public static PathPaymentStrictReceiveOp fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PathPaymentStrictReceiveOp fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
