// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PathPaymentStrictSendOp's original definition in the XDR file is:
 *
 * <pre>
 * struct PathPaymentStrictSendOp
 * {
 *     Asset sendAsset;  // asset we pay with
 *     int64 sendAmount; // amount of sendAsset to send (excluding fees)
 *
 *     MuxedAccount destination; // recipient of the payment
 *     Asset destAsset;          // what they end up with
 *     int64 destMin;            // the minimum amount of dest asset to
 *                               // be received
 *                               // The operation will fail if it can't be met
 *
 *     Asset path&lt;5&gt;; // additional hops it must go through to get there
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PathPaymentStrictSendOp implements XdrElement {
  private Asset sendAsset;
  private Int64 sendAmount;
  private MuxedAccount destination;
  private Asset destAsset;
  private Int64 destMin;
  private Asset[] path;

  public void encode(XdrDataOutputStream stream) throws IOException {
    sendAsset.encode(stream);
    sendAmount.encode(stream);
    destination.encode(stream);
    destAsset.encode(stream);
    destMin.encode(stream);
    int pathSize = getPath().length;
    stream.writeInt(pathSize);
    for (int i = 0; i < pathSize; i++) {
      path[i].encode(stream);
    }
  }

  public static PathPaymentStrictSendOp decode(XdrDataInputStream stream) throws IOException {
    PathPaymentStrictSendOp decodedPathPaymentStrictSendOp = new PathPaymentStrictSendOp();
    decodedPathPaymentStrictSendOp.sendAsset = Asset.decode(stream);
    decodedPathPaymentStrictSendOp.sendAmount = Int64.decode(stream);
    decodedPathPaymentStrictSendOp.destination = MuxedAccount.decode(stream);
    decodedPathPaymentStrictSendOp.destAsset = Asset.decode(stream);
    decodedPathPaymentStrictSendOp.destMin = Int64.decode(stream);
    int pathSize = stream.readInt();
    decodedPathPaymentStrictSendOp.path = new Asset[pathSize];
    for (int i = 0; i < pathSize; i++) {
      decodedPathPaymentStrictSendOp.path[i] = Asset.decode(stream);
    }
    return decodedPathPaymentStrictSendOp;
  }

  public static PathPaymentStrictSendOp fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PathPaymentStrictSendOp fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
