// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCPBallot's original definition in the XDR file is:
 *
 * <pre>
 * struct SCPBallot
 * {
 *     uint32 counter; // n
 *     Value value;    // x
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCPBallot implements XdrElement {
  private Uint32 counter;
  private Value value;

  public void encode(XdrDataOutputStream stream) throws IOException {
    counter.encode(stream);
    value.encode(stream);
  }

  public static SCPBallot decode(XdrDataInputStream stream) throws IOException {
    SCPBallot decodedSCPBallot = new SCPBallot();
    decodedSCPBallot.counter = Uint32.decode(stream);
    decodedSCPBallot.value = Value.decode(stream);
    return decodedSCPBallot;
  }

  public static SCPBallot fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPBallot fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
