// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SignerKey's original definition in the XDR file is:
 *
 * <pre>
 * union SignerKey switch (SignerKeyType type)
 * {
 * case SIGNER_KEY_TYPE_ED25519:
 *     uint256 ed25519;
 * case SIGNER_KEY_TYPE_PRE_AUTH_TX:
 *     /&#42; SHA-256 Hash of TransactionSignaturePayload structure &#42;/
 *     uint256 preAuthTx;
 * case SIGNER_KEY_TYPE_HASH_X:
 *     /&#42; Hash of random 256 bit preimage X &#42;/
 *     uint256 hashX;
 * case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD:
 *     struct
 *     {
 *         /&#42; Public key that must sign the payload. &#42;/
 *         uint256 ed25519;
 *         /&#42; Payload to be raw signed by ed25519. &#42;/
 *         opaque payload&lt;64&gt;;
 *     } ed25519SignedPayload;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SignerKey implements XdrElement {
  private SignerKeyType discriminant;
  private Uint256 ed25519;
  private Uint256 preAuthTx;
  private Uint256 hashX;
  private SignerKeyEd25519SignedPayload ed25519SignedPayload;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SIGNER_KEY_TYPE_ED25519:
        ed25519.encode(stream);
        break;
      case SIGNER_KEY_TYPE_PRE_AUTH_TX:
        preAuthTx.encode(stream);
        break;
      case SIGNER_KEY_TYPE_HASH_X:
        hashX.encode(stream);
        break;
      case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD:
        ed25519SignedPayload.encode(stream);
        break;
    }
  }

  public static SignerKey decode(XdrDataInputStream stream) throws IOException {
    SignerKey decodedSignerKey = new SignerKey();
    SignerKeyType discriminant = SignerKeyType.decode(stream);
    decodedSignerKey.setDiscriminant(discriminant);
    switch (decodedSignerKey.getDiscriminant()) {
      case SIGNER_KEY_TYPE_ED25519:
        decodedSignerKey.ed25519 = Uint256.decode(stream);
        break;
      case SIGNER_KEY_TYPE_PRE_AUTH_TX:
        decodedSignerKey.preAuthTx = Uint256.decode(stream);
        break;
      case SIGNER_KEY_TYPE_HASH_X:
        decodedSignerKey.hashX = Uint256.decode(stream);
        break;
      case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD:
        decodedSignerKey.ed25519SignedPayload = SignerKeyEd25519SignedPayload.decode(stream);
        break;
    }
    return decodedSignerKey;
  }

  public static SignerKey fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SignerKey fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * SignerKeyEd25519SignedPayload's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         /&#42; Public key that must sign the payload. &#42;/
   *         uint256 ed25519;
   *         /&#42; Payload to be raw signed by ed25519. &#42;/
   *         opaque payload&lt;64&gt;;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class SignerKeyEd25519SignedPayload implements XdrElement {
    private Uint256 ed25519;
    private byte[] payload;

    public void encode(XdrDataOutputStream stream) throws IOException {
      ed25519.encode(stream);
      int payloadSize = payload.length;
      stream.writeInt(payloadSize);
      stream.write(getPayload(), 0, payloadSize);
    }

    public static SignerKeyEd25519SignedPayload decode(XdrDataInputStream stream)
        throws IOException {
      SignerKeyEd25519SignedPayload decodedSignerKeyEd25519SignedPayload =
          new SignerKeyEd25519SignedPayload();
      decodedSignerKeyEd25519SignedPayload.ed25519 = Uint256.decode(stream);
      int payloadSize = stream.readInt();
      decodedSignerKeyEd25519SignedPayload.payload = new byte[payloadSize];
      stream.read(decodedSignerKeyEd25519SignedPayload.payload, 0, payloadSize);
      return decodedSignerKeyEd25519SignedPayload;
    }

    public static SignerKeyEd25519SignedPayload fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static SignerKeyEd25519SignedPayload fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
