// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanResources's original definition in the XDR file is:
 *
 * <pre>
 * struct SorobanResources
 * {
 *     // The ledger footprint of the transaction.
 *     LedgerFootprint footprint;
 *     // The maximum number of instructions this transaction can use
 *     uint32 instructions;
 *
 *     // The maximum number of bytes this transaction can read from disk backed entries
 *     uint32 diskReadBytes;
 *     // The maximum number of bytes this transaction can write to ledger
 *     uint32 writeBytes;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanResources implements XdrElement {
  private LedgerFootprint footprint;
  private Uint32 instructions;
  private Uint32 diskReadBytes;
  private Uint32 writeBytes;

  public void encode(XdrDataOutputStream stream) throws IOException {
    footprint.encode(stream);
    instructions.encode(stream);
    diskReadBytes.encode(stream);
    writeBytes.encode(stream);
  }

  public static SorobanResources decode(XdrDataInputStream stream) throws IOException {
    SorobanResources decodedSorobanResources = new SorobanResources();
    decodedSorobanResources.footprint = LedgerFootprint.decode(stream);
    decodedSorobanResources.instructions = Uint32.decode(stream);
    decodedSorobanResources.diskReadBytes = Uint32.decode(stream);
    decodedSorobanResources.writeBytes = Uint32.decode(stream);
    return decodedSorobanResources;
  }

  public static SorobanResources fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanResources fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
