// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanResourcesExtV0's original definition in the XDR file is:
 *
 * <pre>
 * struct SorobanResourcesExtV0
 * {
 *     // Vector of indices representing what Soroban
 *     // entries in the footprint are archived, based on the
 *     // order of keys provided in the readWrite footprint.
 *     uint32 archivedSorobanEntries&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanResourcesExtV0 implements XdrElement {
  private Uint32[] archivedSorobanEntries;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int archivedSorobanEntriesSize = getArchivedSorobanEntries().length;
    stream.writeInt(archivedSorobanEntriesSize);
    for (int i = 0; i < archivedSorobanEntriesSize; i++) {
      archivedSorobanEntries[i].encode(stream);
    }
  }

  public static SorobanResourcesExtV0 decode(XdrDataInputStream stream) throws IOException {
    SorobanResourcesExtV0 decodedSorobanResourcesExtV0 = new SorobanResourcesExtV0();
    int archivedSorobanEntriesSize = stream.readInt();
    decodedSorobanResourcesExtV0.archivedSorobanEntries = new Uint32[archivedSorobanEntriesSize];
    for (int i = 0; i < archivedSorobanEntriesSize; i++) {
      decodedSorobanResourcesExtV0.archivedSorobanEntries[i] = Uint32.decode(stream);
    }
    return decodedSorobanResourcesExtV0;
  }

  public static SorobanResourcesExtV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanResourcesExtV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
