// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanTransactionMetaExtV1's original definition in the XDR file is:
 *
 * <pre>
 * struct SorobanTransactionMetaExtV1
 * {
 *     ExtensionPoint ext;
 *
 *     // The following are the components of the overall Soroban resource fee
 *     // charged for the transaction.
 *     // The following relation holds:
 *     // `resourceFeeCharged = totalNonRefundableResourceFeeCharged + totalRefundableResourceFeeCharged`
 *     // where `resourceFeeCharged` is the overall fee charged for the
 *     // transaction. Also, `resourceFeeCharged` &lt;= `sorobanData.resourceFee`
 *     // i.e.we never charge more than the declared resource fee.
 *     // The inclusion fee for charged the Soroban transaction can be found using
 *     // the following equation:
 *     // `result.feeCharged = resourceFeeCharged + inclusionFeeCharged`.
 *
 *     // Total amount (in stroops) that has been charged for non-refundable
 *     // Soroban resources.
 *     // Non-refundable resources are charged based on the usage declared in
 *     // the transaction envelope (such as `instructions`, `readBytes` etc.) and
 *     // is charged regardless of the success of the transaction.
 *     int64 totalNonRefundableResourceFeeCharged;
 *     // Total amount (in stroops) that has been charged for refundable
 *     // Soroban resource fees.
 *     // Currently this comprises the rent fee (`rentFeeCharged`) and the
 *     // fee for the events and return value.
 *     // Refundable resources are charged based on the actual resources usage.
 *     // Since currently refundable resources are only used for the successful
 *     // transactions, this will be `0` for failed transactions.
 *     int64 totalRefundableResourceFeeCharged;
 *     // Amount (in stroops) that has been charged for rent.
 *     // This is a part of `totalNonRefundableResourceFeeCharged`.
 *     int64 rentFeeCharged;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanTransactionMetaExtV1 implements XdrElement {
  private ExtensionPoint ext;
  private Int64 totalNonRefundableResourceFeeCharged;
  private Int64 totalRefundableResourceFeeCharged;
  private Int64 rentFeeCharged;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    totalNonRefundableResourceFeeCharged.encode(stream);
    totalRefundableResourceFeeCharged.encode(stream);
    rentFeeCharged.encode(stream);
  }

  public static SorobanTransactionMetaExtV1 decode(XdrDataInputStream stream) throws IOException {
    SorobanTransactionMetaExtV1 decodedSorobanTransactionMetaExtV1 =
        new SorobanTransactionMetaExtV1();
    decodedSorobanTransactionMetaExtV1.ext = ExtensionPoint.decode(stream);
    decodedSorobanTransactionMetaExtV1.totalNonRefundableResourceFeeCharged = Int64.decode(stream);
    decodedSorobanTransactionMetaExtV1.totalRefundableResourceFeeCharged = Int64.decode(stream);
    decodedSorobanTransactionMetaExtV1.rentFeeCharged = Int64.decode(stream);
    return decodedSorobanTransactionMetaExtV1;
  }

  public static SorobanTransactionMetaExtV1 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanTransactionMetaExtV1 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
