// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TimeSlicedSurveyRequestMessage's original definition in the XDR file is:
 *
 * <pre>
 * struct TimeSlicedSurveyRequestMessage
 * {
 *     SurveyRequestMessage request;
 *     uint32 nonce;
 *     uint32 inboundPeersIndex;
 *     uint32 outboundPeersIndex;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TimeSlicedSurveyRequestMessage implements XdrElement {
  private SurveyRequestMessage request;
  private Uint32 nonce;
  private Uint32 inboundPeersIndex;
  private Uint32 outboundPeersIndex;

  public void encode(XdrDataOutputStream stream) throws IOException {
    request.encode(stream);
    nonce.encode(stream);
    inboundPeersIndex.encode(stream);
    outboundPeersIndex.encode(stream);
  }

  public static TimeSlicedSurveyRequestMessage decode(XdrDataInputStream stream)
      throws IOException {
    TimeSlicedSurveyRequestMessage decodedTimeSlicedSurveyRequestMessage =
        new TimeSlicedSurveyRequestMessage();
    decodedTimeSlicedSurveyRequestMessage.request = SurveyRequestMessage.decode(stream);
    decodedTimeSlicedSurveyRequestMessage.nonce = Uint32.decode(stream);
    decodedTimeSlicedSurveyRequestMessage.inboundPeersIndex = Uint32.decode(stream);
    decodedTimeSlicedSurveyRequestMessage.outboundPeersIndex = Uint32.decode(stream);
    return decodedTimeSlicedSurveyRequestMessage;
  }

  public static TimeSlicedSurveyRequestMessage fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TimeSlicedSurveyRequestMessage fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
