// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionEvent's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionEvent {
 *     TransactionEventStage stage;  // Stage at which an event has occurred.
 *     ContractEvent event;  // The contract event that has occurred.
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionEvent implements XdrElement {
  private TransactionEventStage stage;
  private ContractEvent event;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stage.encode(stream);
    event.encode(stream);
  }

  public static TransactionEvent decode(XdrDataInputStream stream) throws IOException {
    TransactionEvent decodedTransactionEvent = new TransactionEvent();
    decodedTransactionEvent.stage = TransactionEventStage.decode(stream);
    decodedTransactionEvent.event = ContractEvent.decode(stream);
    return decodedTransactionEvent;
  }

  public static TransactionEvent fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionEvent fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
